/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.julia.control.management;

import java.util.ArrayList;
import java.util.List;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.util.Fractal;

import org.ow2.jasmine.jade.fractal.api.control.ApplicationController;

/**
 * 
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 *
 */
public class ApplicationControllerMixin implements ApplicationController {

	// -------------------------------------------------------------------------
	// Private constructor
	// -------------------------------------------------------------------------
	private ApplicationControllerMixin() {
	}

	// -------------------------------------------------------------------------
	// Implementation of ApplicationController interface
	// -------------------------------------------------------------------------

	/* (non-Javadoc)
	 * @see org.ow2.jasmine.jade.fractal.api.control.ApplicationController#getApplications()
	 */
	public Component[] getApplications() {

		List<Component> applications = new ArrayList<Component>();
		
		Component managedElements[] = _this_weaveableCC.getFcSubComponents();
		
		for(Component managedElement : managedElements){
			
			try {
				
				Component parents[] = Fractal.getSuperController(managedElement).getFcSuperComponents();
				
				if(parents.length == 1)
					applications.add(managedElement);
				
			} catch (NoSuchInterfaceException ignored) {
			}
			
		}
		
		return applications.toArray(new Component[]{});
	}

	// -------------------------------------------------------------------------
	// Fields and methods required by the mixin class in the base class
	// -------------------------------------------------------------------------

	/**
	 * The {@link ContentController} interface of the component to which this
	 * controller object belongs.
	 */
	public ContentController _this_weaveableCC;

}
