/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.julia.control.osgi;

import java.util.HashMap;
import java.util.Map;

import org.objectweb.fractal.api.Component;
import org.osgi.framework.BundleContext;

import org.ow2.jasmine.jade.fractal.api.control.OSGiContextController;

/**
 * Provide a basic implementation of the
 * {@link org.ow2.jasmine.jade.fractal.api.control.OSGiContextController} interface.
 * 
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 * 
 */
public class BasicOSGiContextControllerMixin implements OSGiContextController {

	/**
	 * 
	 */
	public BundleContext bundleCtx = null;

	/**
	 * 
	 */
	private Map<Component, Long> bundlesIds = new HashMap<Component, Long>();

	// ------------------------------------------------------------------------
	// Implementation of OSGiContextController interface
	// ------------------------------------------------------------------------

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.OSGiContextController#setBundleContext(org.osgi.framework.BundleContext)
	 */
	public void setBundleContext(BundleContext ctx) {
		this.bundleCtx = ctx;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.OSGiContextController#getBundleContext()
	 */
	public BundleContext getBundleContext() {
		return this.bundleCtx;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.OSGiContextController#addBundleId(org.objectweb.fractal.api.Component,
	 *      long)
	 */
	public void addBundleId(Component component, long bundleId) {
		bundlesIds.put(component, bundleId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.OSGiContextController#getBundleId(org.objectweb.fractal.api.Component)
	 */
	public long getBundleId(Component component) {
		return bundlesIds.get(component);
	}
}
