/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.julia.control.reversebinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;

import org.ow2.jasmine.jade.fractal.api.control.ReverseBindingController;

/**
 * Provides a basic implementation of the {@link ReverseBindingController}
 * interface.
 * 
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 * @author <a href="mailto:fabienne.boyer@inrialpes.fr">Fabienne Boyer</a>
 */

public abstract class BasicReverseBindingControllerMixin implements
		ReverseBindingController {

	/**
	 * the reverse bindings of the component to which this controller is
	 * assigned
	 */
	public Map<String, List<Object>> reverseBinding;

	// -------------------------------------------------------------------------
	// Private constructor
	// -------------------------------------------------------------------------

	private BasicReverseBindingControllerMixin() {
	}

	// ------------------------------------------------------------------------
	// Implementation of ReverseBindingController interface
	// ------------------------------------------------------------------------

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.ReverseBindingController#bindSource(java.lang.String,
	 *      java.lang.Object)
	 */
	public void bindSource(String serverItfName, Object clientItf)
			throws NoSuchInterfaceException, IllegalBindingException,
			IllegalLifeCycleException {

		List<Object> reverseBindingList = null;
		
		if (reverseBinding == null) {
			reverseBinding = new HashMap<String, List<Object>>();
		}
		
		try {
			if (reverseBinding.containsKey(serverItfName)) {
				reverseBinding.get(serverItfName).add(clientItf);
			} else {
				reverseBindingList = new ArrayList<Object>();
				reverseBindingList.add(clientItf);
				reverseBinding.put(serverItfName, reverseBindingList);
			}
		} catch (Exception e) {
			throw new IllegalBindingException(e.getMessage());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.ReverseBindingController#unbindSource(java.lang.String,
	 *      java.lang.Object)
	 */
	public void unbindSource(String serverItfName, Object clientItf)
			throws NoSuchInterfaceException, IllegalBindingException,
			IllegalLifeCycleException {

		List<Object> res = reverseBinding.get(serverItfName);
		if (res != null) {
			res.remove(clientItf);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.ReverseBindingController#lookupBindingSource(java.lang.String)
	 */
	public Object[] lookupBindingSource(String serverItfName)
			throws NoSuchInterfaceException {

		List<Object> res = null;

		try {
			res = reverseBinding.get(serverItfName);
		} catch (Exception e) {
			throw new NoSuchInterfaceException(serverItfName);
		}
		if (res != null) {
			return res.toArray();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ow2.jasmine.jade.fractal.api.control.ReverseBindingController#listSource()
	 */
	public String[] listSource() {
		if (reverseBinding == null || reverseBinding.isEmpty()) {
			return null;
		}
		return reverseBinding.keySet().toArray(
				new String[reverseBinding.size()]);
	}

}