/***
 * Jade-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.fractal.util;

import java.util.Vector;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.deployment.local.api.GenericInstallingFactory;
import org.objectweb.fractal.util.Fractal;

import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.GenericInstallingFactoryContextController;
import org.ow2.jasmine.jade.fractal.api.control.OSGiContextController;
import org.ow2.jasmine.jade.fractal.api.control.ReverseBindingController;

/**
 * Provides static methods to access controller interfaces, defined in
 * Jade-Fractal, of Fractal components.
 * 
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 * 
 */
public class FractalUtil {

	/**
	 * Returns the {@link GenericAttributeController} interface of the given
	 * component.
	 * 
	 * @param component
	 *            a component.
	 * @return the {@link GenericAttributeController} interface of the given
	 *         component.
	 * @throws NoSuchInterfaceException
	 *             if there is no such interface.
	 */

	public static GenericAttributeController getGenericAttributeController(
			final Component component) throws NoSuchInterfaceException {
		return (GenericAttributeController) component
				.getFcInterface("generic-attribute-controller");
	}

	/**
	 * Returns the {@link OSGiContextController} interface of the given
	 * component.
	 * 
	 * @param component
	 *            a component.
	 * @return the {@link OSGiContextController} interface of the given
	 *         component.
	 * @throws NoSuchInterfaceException
	 *             if there is no such interface.
	 */

	public static OSGiContextController getOSGiContextController(
			final Component component) throws NoSuchInterfaceException {

		return (OSGiContextController) component
				.getFcInterface("osgi-context-controller");
	}

	/**
	 * Returns the {@link GenericInstallingFactoryContextController} interface of the given
	 * component.
	 * 
	 * @param component
	 *            a component.
	 * @return the {@link GenericInstallingFactoryContextController} interface of the given
	 *         component.
	 * @throws NoSuchInterfaceException
	 *             if there is no such interface.
	 */

	public static GenericInstallingFactoryContextController getGenericInstallingFactoryContextController(
			final Component component) throws NoSuchInterfaceException {

		return (GenericInstallingFactoryContextController) component
				.getFcInterface("generic-installing-factory-context-controller");
	}

	/**
	 * Returns the {@link ReverseBindingController} interface of the given
	 * component.
	 * 
	 * @param component
	 *            a component.
	 * @return the {@link ReverseBindingController} interface of the given
	 *         component.
	 * @throws NoSuchInterfaceException
	 *             if there is no such interface.
	 */
	public static ReverseBindingController getReverseBindingController(
			final Component component) throws NoSuchInterfaceException {

		return (ReverseBindingController) component
				.getFcInterface("reverse-binding-controller");
	}

	/**
	 * Returns the {@link GenericInstallingFactory} interface of the given
	 * component.
	 * 
	 * @param component
	 *            a component.
	 * @return the {@link GenericInstallingFactory} interface of the given
	 *         component.
	 * @throws NoSuchInterfaceException
	 *             if there is no such interface.
	 */
	public static GenericInstallingFactory getGenericInstallingFactory(
			Component component) throws NoSuchInterfaceException {
		return (GenericInstallingFactory) component
				.getFcInterface("generic-installing-factory");
	}

	/**
	 * @param sup
	 * @param sub
	 * @return
	 * 
	 * @deprecated
	 */
	public static Component getSubComponent(Component sup, String sub) {

		Component res = sup;

		while (sub != null) {
			String subsub;
			int i = sub.indexOf("/");
			if (i != -1) {
				subsub = sub.substring(0, i);
				sub = sub.substring(i + 1);
			} else {
				subsub = sub;
				sub = null;
			}
			res = subcomp(res, subsub);
		}

		return res;
	}

	/**
	 * @param comp
	 * @param name
	 * @return
	 * @deprecated
	 */
	private static Component subcomp(Component comp, String name) {

		try {
			ContentController cc = Fractal.getContentController(comp);
			for (Component sc : cc.getFcSubComponents()) {
				NameController nc = Fractal.getNameController(sc);
				if (name.equals(nc.getFcName())) {
					return sc;
				}
			}
		} catch (NoSuchInterfaceException e) {
			e.printStackTrace();
			return null;
		}
		return null;
	}

	/**
	 * Test if the component passed as parameter has a client itf whose
	 * signature correspond to the signature passed as parameter.
	 * 
	 * @param cmp
	 *            the component to be tested
	 * @param signature
	 *            the signature of the itf
	 * @return an array of interface object having this signature (these
	 *         interfaces are client/external) or null.
	 * @deprecated
	 */
	public static Interface[] getCmpItf(Component cmp, String signature) {// throws
		// NoSuchInterfaceException
		// {

		Vector res = new Vector(10, 10);

		Object[] itf = cmp.getFcInterfaces();

		if (itf != null) {
			for (int i = 0; i < itf.length; i++) {
				if (!(((InterfaceType) (((Interface) itf[i]).getFcItfType()))
						.isFcClientItf())) {

					if (((InterfaceType) (((Interface) itf[i]).getFcItfType()))
							.getFcItfSignature().equals(signature)) {
						res.add(itf[i]);
					}
				}
			}
			return (Interface[]) res.toArray(new Interface[0]);
		} else
			return null;
	}

	/**
	 * utility method to find a subcomponent from a component root.
	 * 
	 * @param c
	 *            the component root
	 * @param sub
	 *            the full path name of the component to find.
	 * @return the component or null if the cmp is not found.
	 * 
	 * example : if C0 has 3 subcmp : C1,C2,C3 if C2 has 2 subcmp : C4,C5
	 * find(C0,"C4/C5") will return the ref of C5
	 * 
	 * @deprecated
	 */
	public static Component find(Component c, String sub) {
		int idx;
		String cmp = null;
		String newPath;
		Component subc = null;

		try {

			idx = sub.indexOf('/');
			if (idx != -1) {
				// find the cmp and follow the path
				cmp = sub.substring(0, idx);
				newPath = sub.substring(idx + 1);
				subc = search(c, cmp);
				if (subc == null)
					return null;
				return find(subc, newPath);
			} else {
				// find the subcmp
				return search(c, sub);
			}

		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * @param c
	 * @param subcmp
	 * @return
	 * @deprecated
	 */
	private static Component search(Component c, String subcmp) {

		try {
			ContentController cc = Fractal.getContentController(c);
			Component[] sub = cc.getFcSubComponents();

			for (int i = 0; i < sub.length; i++) {
				try {
					if (Fractal.getNameController(sub[i]).getFcName().equals(
							subcmp))
						return sub[i];
				} catch (NoSuchInterfaceException e1) {
					// no name ctrler ignore it
				}
			}

		} catch (Exception e) {
			return null;
		}
		return null;
	}

}
