/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.fractal.adl.attributes;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.deployment.scheduling.component.api.InstanceProviderTask;
import org.objectweb.deployment.scheduling.component.lib.AbstractAttributeSetterTask;
import org.objectweb.deployment.scheduling.core.api.Task;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.TaskMap;
import org.objectweb.fractal.adl.attributes.Attribute;
import org.objectweb.fractal.adl.attributes.AttributeBuilder;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.api.control.BindingController;
import org.ow2.jasmine.jade.fractal.adl.attributes.GenericAttributesContainer;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;

public class AttributeCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public AttributeBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (AttributeBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        AttributeTask t;
        int i;
        Attribute[] attrs;
        Task startTask;
        InstanceProviderTask createTask;
        Object attributes;
        if (container instanceof AttributesContainer && (attributes = ((AttributesContainer)container).getAttributes()) != null) {
            createTask = (InstanceProviderTask)tasks.getTask("create", (Object)container);
            startTask = tasks.getTask("start", (Object)container);
            attrs = attributes.getAttributes();
            for (i = 0; i < attrs.length; ++i) {
                try {
                    tasks.getTask("attr" + attrs[i].getName(), (Object)container);
                    continue;
                }
                catch (NoSuchElementException e) {
                    t = new AttributeTask(this.builder, attributes.getSignature(), attrs[i].getName(), attrs[i].getValue());
                    t.setInstanceProviderTask(createTask);
                    startTask.addPreviousTask((Task)t);
                    tasks.addTask("attr" + attrs[i].getName(), (Object)container, (Task)t);
                }
            }
        }
        if (container instanceof GenericAttributesContainer && (attributes = ((GenericAttributesContainer)container).getGenericAttributes()) != null) {
            createTask = (InstanceProviderTask)tasks.getTask("create", (Object)container);
            startTask = tasks.getTask("start", (Object)container);
            attrs = attributes.getAttributes();
            for (i = 0; i < attrs.length; ++i) {
                try {
                    tasks.getTask("attr" + attrs[i].getName(), (Object)container);
                    continue;
                }
                catch (NoSuchElementException e) {
                    t = new AttributeTask(this.builder, GenericAttributeController.class.getName(), attrs[i].getName(), attrs[i].getValue());
                    t.setInstanceProviderTask(createTask);
                    startTask.addPreviousTask((Task)t);
                    tasks.addTask("attr" + attrs[i].getName(), (Object)container, (Task)t);
                }
            }
        }
    }

    static class AttributeTask
    extends AbstractAttributeSetterTask {
        private AttributeBuilder builder;
        private String attributeController;
        private String name;

        public AttributeTask(AttributeBuilder builder, String attributeController, String name, String value) {
            this.builder = builder;
            this.attributeController = attributeController;
            this.name = name;
            this.setValue(value);
        }

        public void execute(Object context) throws Exception {
            Object component = this.getInstanceProviderTask().getInstance();
            this.builder.setAttribute(component, this.attributeController, this.name, (String)this.getValue(), context);
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[AttributeTask(" + this.name + "," + this.getValue() + ")]";
        }
    }
}

