/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.fractal.adl.implementations;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.deployment.scheduling.component.api.FactoryProviderTask;
import org.objectweb.deployment.scheduling.component.lib.AbstractInstanceProviderTask;
import org.objectweb.deployment.scheduling.core.api.Task;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.TaskMap;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.adl.implementations.ControllerContainer;
import org.objectweb.fractal.adl.implementations.Implementation;
import org.objectweb.fractal.adl.implementations.ImplementationBuilder;
import org.objectweb.fractal.adl.implementations.ImplementationContainer;
import org.objectweb.fractal.adl.implementations.TemplateControllerContainer;
import org.objectweb.fractal.adl.nodes.VirtualNode;
import org.objectweb.fractal.adl.nodes.VirtualNodeContainer;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.util.Fractal;
import org.ow2.jasmine.jade.fractal.adl.attributes.GenericAttributesContainer;

public class ImplementationCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public ImplementationBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (ImplementationBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        TemplateControllerContainer tcc;
        ControllerContainer cc;
        ImplementationContainer ic;
        Implementation i;
        VirtualNode virtualNode;
        String virtualNodeName = null;
        Task virtualNodeCreationTask = null;
        if (container instanceof VirtualNodeContainer && (virtualNode = ((VirtualNodeContainer)container).getVirtualNode()) != null) {
            virtualNodeName = virtualNode.getName();
            try {
                virtualNodeCreationTask = tasks.getTask("allocNode", (Object)virtualNodeName);
            }
            catch (NoSuchElementException ignored) {
                // empty catch block
            }
        }
        boolean template = context != null && "true".equals(context.get("template"));
        String implementation = null;
        if (container instanceof ImplementationContainer && (i = (ic = (ImplementationContainer)container).getImplementation()) != null) {
            implementation = i.getClassName();
        }
        String controller = null;
        if (container instanceof ControllerContainer && (cc = (ControllerContainer)container).getController() != null) {
            controller = cc.getController().getDescriptor();
        }
        String templateController = null;
        if (container instanceof TemplateControllerContainer && (tcc = (TemplateControllerContainer)container).getTemplateController() != null) {
            templateController = tcc.getTemplateController().getDescriptor();
            template = true;
        }
        String name = null;
        if (container instanceof Definition) {
            name = ((Definition)container).getName();
        } else if (container instanceof Component) {
            name = ((Component)container).getName();
        }
        String definition = null;
        definition = container instanceof Definition ? name : (String)((Node)container).astGetDecoration("definition");
        boolean attrs = false;
        if (container instanceof AttributesContainer) {
            boolean bl = attrs = ((AttributesContainer)container).getAttributes() != null;
        }
        if (!attrs && container instanceof GenericAttributesContainer) {
            attrs = ((GenericAttributesContainer)container).getGenericAttributes() != null;
        }
        Component[] comps = container.getComponents();
        try {
            tasks.getTask("create", (Object)container);
        }
        catch (NoSuchElementException e) {
            AbstractInstanceProviderTask createTask;
            if (comps.length > 0 || implementation == null) {
                if (implementation != null) {
                    throw new ADLException("Implementation must be empty", (Node)container);
                }
                if (controller == null) {
                    controller = "composite";
                }
                if (template) {
                    if (templateController == null) {
                        templateController = attrs ? "parametricCompositeTemplate" : "compositeTemplate";
                    }
                    createTask = this.newCreateTask(path, container, name, definition, templateController, new Object[]{controller, null}, context);
                } else {
                    createTask = this.newCreateTask(path, container, name, definition, controller, null, context);
                }
            } else {
                if (controller == null) {
                    controller = "primitive";
                }
                if (template) {
                    if (templateController == null) {
                        templateController = attrs ? "parametricPrimitiveTemplate" : "primitiveTemplate";
                    }
                    if (virtualNodeCreationTask != null) {
                        createTask = this.newRemoteCreateTask(path, container, name, definition, templateController, new Object[]{controller, implementation}, virtualNodeCreationTask, context);
                        createTask.addPreviousTask(virtualNodeCreationTask);
                    } else {
                        createTask = this.newCreateTask(path, container, name, definition, templateController, new Object[]{controller, implementation}, context);
                    }
                } else if (virtualNodeCreationTask != null) {
                    createTask = this.newRemoteCreateTask(path, container, name, definition, controller, implementation, virtualNodeCreationTask, context);
                    createTask.addPreviousTask(virtualNodeCreationTask);
                } else {
                    createTask = this.newCreateTask(path, container, name, definition, controller, implementation, context);
                }
            }
            FactoryProviderTask typeTask = (FactoryProviderTask)tasks.getTask("type", (Object)container);
            createTask.setFactoryProviderTask(typeTask);
            tasks.addTask("create", (Object)container, (Task)createTask);
        }
    }

    public AbstractInstanceProviderTask newCreateTask(List path, ComponentContainer container, String name, String definition, Object controller, Object implementation, Map context) {
        return new CreateTask(this.builder, name, definition, controller, implementation);
    }

    public AbstractInstanceProviderTask newRemoteCreateTask(List path, ComponentContainer container, String name, String definition, Object controller, Object implementation, Task virtualNodeCreationTask, Map context) {
        return new RemoteCreateTask(this.builder, virtualNodeCreationTask, name, definition, controller, implementation);
    }

    static class RemoteCreateTask
    extends CreateTask {
        Task virtualNodeCreationTask;

        public RemoteCreateTask(ImplementationBuilder builder, Task virtualNodeCreationTask, String name, String definition, Object controllerDesc, Object contentDesc) {
            super(builder, name, definition, controllerDesc, contentDesc);
            this.virtualNodeCreationTask = virtualNodeCreationTask;
        }

        public void execute(Object context) throws Exception {
            if (this.getInstance() != null) {
                return;
            }
            Object type = this.getFactoryProviderTask().getFactory();
            org.objectweb.fractal.api.Component node = (org.objectweb.fractal.api.Component)this.virtualNodeCreationTask.getResult();
            if (node == null) {
                return;
            }
            String physicalNodeName = Fractal.getNameController((org.objectweb.fractal.api.Component)node).getFcName();
            String factoryName = "";
            factoryName = physicalNodeName.equals("jadeboot") ? InetAddress.getLocalHost().getCanonicalHostName() : physicalNodeName;
            ((Map)context).put("factoryName", factoryName);
            Object result = this.builder.createComponent(type, this.name, this.definition, this.controllerDesc, this.contentDesc, context);
            this.setInstance(result);
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[CreateTask(" + this.name + "," + this.controllerDesc + "," + this.contentDesc + ")]";
        }
    }

    static class CreateTask
    extends AbstractInstanceProviderTask {
        ImplementationBuilder builder;
        String name;
        String definition;
        Object controllerDesc;
        Object contentDesc;

        public CreateTask(ImplementationBuilder builder, String name, String definition, Object controllerDesc, Object contentDesc) {
            this.builder = builder;
            this.name = name;
            this.definition = definition;
            this.controllerDesc = controllerDesc;
            this.contentDesc = contentDesc;
        }

        public void execute(Object context) throws Exception {
            if (this.getInstance() != null) {
                return;
            }
            Object type = this.getFactoryProviderTask().getFactory();
            Object result = this.builder.createComponent(type, this.name, this.definition, this.controllerDesc, this.contentDesc, context);
            this.setInstance(result);
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[CreateTask(" + this.name + "," + this.controllerDesc + "," + this.contentDesc + ")]";
        }
    }
}

