/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.fractal.adl.implementations;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.implementations.Controller;
import org.objectweb.fractal.adl.implementations.ControllerContainer;
import org.objectweb.fractal.adl.implementations.Implementation;
import org.objectweb.fractal.adl.implementations.ImplementationContainer;

public class ImplementationLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d);
        return d;
    }

    private void checkNode(Object node) throws ADLException {
        if (node instanceof ImplementationContainer) {
            this.checkImplementationContainer((ImplementationContainer)node);
        }
        if (node instanceof ControllerContainer) {
            this.checkControllerContainer((ControllerContainer)node);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i]);
            }
        }
    }

    private void checkImplementationContainer(ImplementationContainer container) throws ADLException {
        String className;
        Implementation impl = container.getImplementation();
        if (impl != null && (className = impl.getClassName()) == null) {
            throw new ADLException("Implementation class name missing", (Node)impl);
        }
    }

    private void checkControllerContainer(ControllerContainer container) throws ADLException {
        Controller ctrl = container.getController();
        if (ctrl != null && ctrl.getDescriptor() == null) {
            throw new ADLException("Controller descriptor missing", (Node)ctrl);
        }
    }
}

