/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.fractal.fraclet.annotation.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.fraclet.annotation.Attribute;
import org.objectweb.fractal.fraclet.annotation.Cardinality;
import org.objectweb.fractal.fraclet.annotation.Contingency;
import org.objectweb.fractal.fraclet.annotation.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.Interface;
import org.objectweb.fractal.fraclet.annotation.Provides;
import org.objectweb.fractal.fraclet.annotation.Requires;
import org.objectweb.fractal.fraclet.annotation.generator.template.AttributeTemplate;
import org.objectweb.fractal.fraclet.annotation.generator.template.util.None;
import org.objectweb.fractal.fraclet.annotation.processor.util.ADLFileFactory;
import org.ow2.jasmine.jade.fractal.fraclet.annotation.GenericAttribute;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtField;
import spoon.reflect.reference.CtTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentADLGenerator {
    private PrintWriter pw = null;
    private CtClass<?> processedClass;

    public ComponentADLGenerator(CtClass<?> processedClass, FractalComponent fcAnnotation) {
        this.processedClass = processedClass;
        File outFile = ADLFileFactory.createADLFile((File)processedClass.getFactory().getEnvironment().getDefaultFileGenerator().getOutputDirectory(), processedClass);
        try {
            this.pw = new PrintWriter(outFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        ADLFileFactory.printLicence((PrintWriter)this.pw);
        String arguments = "";
        List fields = processedClass.getFields();
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (CtField field : fields) {
            Attribute acAnnotation = (Attribute)field.getAnnotation(Attribute.class);
            if (acAnnotation == null) continue;
            if (acAnnotation.value() == null) {
                attributes.put(field.getSimpleName(), "");
            } else {
                attributes.put(field.getSimpleName(), acAnnotation.value());
            }
            if (acAnnotation.argument() == null || acAnnotation.argument().length() <= 0) continue;
            arguments = arguments + acAnnotation.argument() + ",";
            String argValue = "${" + acAnnotation.argument() + "}";
            attributes.put(field.getSimpleName(), argValue);
        }
        if (arguments != "") {
            arguments = arguments.substring(0, arguments.length() - 1);
        }
        HashMap<String, String> genericAttributes = new HashMap<String, String>();
        for (CtField field : fields) {
            GenericAttribute acAnnotation = (GenericAttribute)field.getAnnotation(GenericAttribute.class);
            if (acAnnotation == null) continue;
            if (acAnnotation.value() == null) {
                genericAttributes.put(field.getSimpleName(), "");
            } else {
                genericAttributes.put(field.getSimpleName(), acAnnotation.value());
            }
            if (acAnnotation.argument() == null || acAnnotation.argument().length() <= 0) continue;
            arguments = arguments + acAnnotation.argument() + ",";
            String argValue = "${" + acAnnotation.argument() + "}";
            genericAttributes.put(field.getSimpleName(), argValue);
        }
        if (arguments != "") {
            arguments = arguments.substring(0, arguments.length() - 1);
        }
        ArrayList itfs = new ArrayList();
        for (CtTypeReference itf : processedClass.getSuperInterfaces()) {
            Interface itfAnnotation = (Interface)itf.getAnnotation(Interface.class);
            if (itfAnnotation == null) continue;
            itfs.add(itf);
        }
        CtTypeReference superClass = processedClass.getSuperclass();
        if (superClass != null && superClass.getAnnotation(FractalComponent.class) != null) {
            itfs.add(superClass);
        }
        this.printBeginDefinition(itfs, arguments);
        for (CtField field : fields) {
            Requires bindingAnnotation = (Requires)field.getAnnotation(Requires.class);
            if (bindingAnnotation == null) continue;
            Class<None> c = bindingAnnotation.signature();
            if (c.equals(Class.class)) {
                c = None.class;
            }
            ADLFileFactory.printItfSignature((PrintWriter)this.pw, (CtField)field, (String)bindingAnnotation.name(), c, (Cardinality)bindingAnnotation.cardinality(), (Contingency)bindingAnnotation.contingency(), (String)"client");
        }
        Provides providesAnnotation = (Provides)processedClass.getAnnotation(Provides.class);
        if (providesAnnotation != null) {
            Interface[] itfAnnotations;
            for (Interface itfAnnotation : itfAnnotations = providesAnnotation.interfaces()) {
                ADLFileFactory.printItfSignature((PrintWriter)this.pw, (String)itfAnnotation.signature().getCanonicalName(), (String)itfAnnotation.name(), (Cardinality)itfAnnotation.cardinality(), (Contingency)itfAnnotation.contingency(), (String)"server");
            }
        }
        String attributeControllerSignature = processedClass.getQualifiedName() + AttributeTemplate.ATTRIBUTESUFFIX;
        this.printContentClass();
        this.printAttributes(attributeControllerSignature, attributes);
        String genericAttributeControllerSignature = "org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController";
        this.printContentClass();
        this.printGenericAttributes(genericAttributeControllerSignature, genericAttributes);
        this.pw.println("  <controller desc=\"" + fcAnnotation.controllerDesc() + "\"/>");
        this.printEndDefinition();
        this.pw.close();
    }

    private void printContentClass() {
        this.pw.println("  <content class=\"" + this.processedClass.getQualifiedName() + "\"/>");
    }

    private void printAttributes(String attributeControllerSignature, Map<String, String> attributes) {
        if (attributes.size() > 0) {
            this.pw.println("  <attributes signature=\"" + attributeControllerSignature + "\">");
            for (String attributeName : attributes.keySet()) {
                this.pw.println("    <attribute name=\"" + attributeName + "\"" + " value=\"" + "" + attributes.get(attributeName) + "\"/>");
            }
            this.pw.println("  </attributes>");
        }
    }

    private void printGenericAttributes(String genericAttributeControllerSignature, Map<String, String> attributes) {
        if (attributes.size() > 0) {
            this.pw.println("  <attributes signature=\"" + genericAttributeControllerSignature + "\">");
            for (String attributeName : attributes.keySet()) {
                this.pw.println("    <attribute name=\"" + attributeName + "\"" + " value=\"" + "" + attributes.get(attributeName) + "\"/>");
            }
            this.pw.println("  </attributes>");
        }
    }

    private void printBeginDefinition(List<CtTypeReference<?>> itfs, String arguments) {
        if (arguments != "") {
            arguments = "arguments=\"" + arguments + "\"";
        }
        if (itfs.size() > 0) {
            String extendedADLFiles = "";
            for (CtTypeReference<?> itf : itfs) {
                extendedADLFiles = extendedADLFiles + itf + ",";
            }
            extendedADLFiles = extendedADLFiles.substring(0, extendedADLFiles.length() - 1);
            this.pw.println("<definition name=\"" + this.processedClass.getQualifiedName() + "\" extends=\"" + extendedADLFiles + "\"" + " " + arguments + ">");
        } else {
            this.pw.println("<definition name=\"" + this.processedClass.getQualifiedName() + "\"" + " " + arguments + ">");
        }
    }

    private void printEndDefinition() {
        this.pw.println("</definition>");
    }
}

