/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.fractal.julia.control.genericattribute;

import java.util.HashMap;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;

public abstract class GenericCompositeAttributeControllerMixin
implements Controller,
GenericAttributeController {
    HashMap<String, String> attributes = null;
    public ContentController _this_weaveableCC;

    private GenericCompositeAttributeControllerMixin() {
    }

    public void initFcController(InitializationContext ic) throws InstantiationException {
        this._super_initFcController(ic);
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        try {
            if (this.attributes == null) {
                throw new NoSuchAttributeException("The attribute " + name + " doesn't exists");
            }
            return this.attributes.get(name);
        }
        catch (Exception e) {
            throw new NoSuchAttributeException(e.getMessage());
        }
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        try {
            if (!this.forwardSetAttribute(name, value)) {
                if (this.attributes == null) {
                    this.attributes = new HashMap(20, 20.0f);
                }
                if (value != null) {
                    this.attributes.put(name, value);
                }
            }
        }
        catch (Exception e) {
            throw new NoSuchAttributeException(e.getMessage());
        }
    }

    public String[] listFcAtt() {
        if (this.attributes != null) {
            Set<String> set = this.attributes.keySet();
            if (set != null) {
                return set.toArray(new String[set.size()]);
            }
            return null;
        }
        return null;
    }

    public void setAttributeNotification(String name, String value) throws NoSuchAttributeException {
        try {
            if (!this.forwardSetAttribute(name, value)) {
                if (this.attributes == null) {
                    this.attributes = new HashMap(20, 20.0f);
                }
                if (value != null) {
                    this.attributes.put(name, value);
                }
            }
        }
        catch (Exception e) {
            throw new NoSuchAttributeException(e.getMessage());
        }
    }

    private boolean forwardSetAttribute(String name, String value) throws NoSuchAttributeException {
        if (name.charAt(0) != '/') {
            return false;
        }
        int nextToken = name.indexOf(47, 1);
        if (nextToken == -1 || nextToken == 1) {
            throw new NoSuchAttributeException("Attribute Name : " + name + " : Wrong format");
        }
        String cmpname = name.substring(1, nextToken);
        String newattr = name.substring(nextToken);
        if ("/".equals(newattr)) {
            throw new NoSuchAttributeException("Attribute Name : " + name + " : Wrong format");
        }
        int primToken = newattr.indexOf(47, 1);
        Component subcmp = this.searchSubCmp(cmpname);
        if (subcmp == null) {
            throw new NoSuchAttributeException("Attribute Name : " + name + " : subcmp " + cmpname + " not found");
        }
        if (primToken == -1) {
            newattr = newattr.substring(1);
        }
        try {
            ((GenericAttributeController)subcmp.getFcInterface("attribute-controller")).setAttribute(newattr, value);
        }
        catch (Exception e) {
            throw new NoSuchAttributeException("Attribute Name : " + name + " : cannot forward to subcmp " + cmpname);
        }
        return true;
    }

    private Component searchSubCmp(String cmpname) {
        String curName = null;
        Component[] subcmp = this._this_weaveableCC.getFcSubComponents();
        for (int i = 0; i < subcmp.length; ++i) {
            try {
                curName = ((NameController)subcmp[i].getFcInterface("name-controller")).getFcName();
                if (!cmpname.equals(curName)) continue;
                return subcmp[i];
            }
            catch (NoSuchInterfaceException e0) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

