/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.adl.attributes;

import org.objectweb.fractal.api.Component;

import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.util.FractalUtil;
import org.ow2.jasmine.jade.reflex.util.DebugReflex;
import org.ow2.jasmine.jade.reflex.util.Logger;

/**
 * A Fractal based implementation of the AttributeBuilder interface. This
 * builder replace the standard builder to provide a support for generic
 * attribute controller.
 * 
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 * 
 * Modified F. Boyer 6/7/5 uses generic-attribute-controller interfaces
 */
public class ReflexFractalAttributeBuilder extends
        org.objectweb.fractal.adl.attributes.FractalAttributeBuilder {

    // -------------------------------------------------------------------------
    // Implementation of the AttributeBuilder interface
    // -------------------------------------------------------------------------

    public void setAttribute(final Object component,
            final String attributeController, final String name,
            final String value, final Object context) throws Exception {

        GenericAttributeController attrcont = null;
        try {

            attrcont = (GenericAttributeController) FractalUtil
                    .getGenericAttributeController((Component) component);
            attrcont.setAttribute(name, value);

        } catch (Exception e) {
            Logger.println(DebugReflex.on,
                    "ReflexFractalAttributeBuilder : Exception " + e);
        }
    }
}
