/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.adl.attributes;

import java.util.Map;

import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.attributes.Attribute;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentDefinition;


/**
 * A {@link org.objectweb.fractal.adl.Loader} to check {@link Attributes} nodes 
 * in definitions. This loader replace the standard loader to provide a support 
 * for generic attribute controller.
 * 
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 */

public class ReflexFractalAttributeLoader extends AbstractLoader {
  
  // --------------------------------------------------------------------------
  // Implementation of the Loader interface
  // --------------------------------------------------------------------------
  
  public Definition load (final String name, final Map context)
    throws ADLException
  {
    Definition d = clientLoader.load(name, context);
    boolean extend = false;
    if (d instanceof ComponentDefinition) {
      extend = ((ComponentDefinition)d).getExtends() != null;
    }
    checkNode(d, extend);
    return d;
  }

  // --------------------------------------------------------------------------
  // Checking methods
  // --------------------------------------------------------------------------
  
  private void checkNode (final Object node, final boolean extend) 
    throws ADLException 
  {
    if (node instanceof AttributesContainer) {
      checkAttributesContainer((AttributesContainer)node, extend);
    }
    if (node instanceof ComponentContainer) {
      Component[] comps = ((ComponentContainer)node).getComponents();
      for (int i = 0; i < comps.length; i++) {
        checkNode(comps[i], extend);
      }
    }
  }

  private void checkAttributesContainer (
    final AttributesContainer container,
    final boolean extend) throws ADLException
  {
    Attributes attrs = container.getAttributes();
    if (attrs != null) {
      String signature = attrs.getSignature();
      if (signature == null) {
        if (!extend) {
          throw new ADLException("Signature missing", (Node)attrs);
        } else {
          return;
        }
      }
      ClassLoader cl = getClass().getClassLoader();
      try {
          cl.loadClass(signature);
      } catch (ClassNotFoundException e) {
        throw new ADLException(
          "Invalid signature '" + signature + "'", (Node)attrs, e);
      }

      Attribute[] attributes = attrs.getAttributes();
      for (int i = 0; i < attributes.length; ++i) {
        String attrName = attributes[i].getName();
        String attrValue = attributes[i].getValue();
        if (attrName == null) {
          throw new ADLException("Attribute name missing", (Node)attributes[i]);
        }
        if (attrValue == null) {
          throw new ADLException("Attribute value missing", (Node)attributes[i]);
        }
        //
        // TODO: THE CHECK ON THE GENERIC ATTRIBUTE CONTROLLER
        //
        /*
        String getterName = 
          "get" + 
          Character.toUpperCase(attrName.charAt(0)) + 
          attrName.substring(1);
        Method getter;
        try {
          getter = c.getMethod(getterName, new Class[0]);
        } catch (Exception e) {
          throw new ADLException("No such attribute", (Node)attributes[i], e);
        }
        Class attrType = getter.getReturnType();
        if (attrType.isPrimitive()) {
          if (attrType.equals(Integer.TYPE)) {
            try {
              Integer.valueOf(attrValue);
            } catch (NumberFormatException e) {
              throw new ADLException(
                "Bad integer value: " + attrValue, (Node)attributes[i]);
            }
          } else if (attrType.equals(Long.TYPE)) {
            try {
              Long.valueOf(attrValue);
            } catch (NumberFormatException e) {
              throw new ADLException(
                "Bad long value: " + attrValue, (Node)attributes[i]);
            }
          } else if (attrType.equals(Float.TYPE)) {
            try {
              Float.valueOf(attrValue);
            } catch (NumberFormatException e) {
              throw new ADLException(
                "Bad float value: " + attrValue, (Node)attributes[i]);
            }
          } else if (attrType.equals(Double.TYPE)) {
            try {
              Double.valueOf(attrValue);
            } catch (NumberFormatException e) {
              throw new ADLException(
                "Bad double value: " + attrValue, (Node)attributes[i]);
            }
          } else if (attrType.equals(Byte.TYPE)) {
            try {
              Byte.valueOf(attrValue);
            } catch (NumberFormatException e) {
              throw new ADLException(
                "Bad byte value: " + attrValue, (Node)attributes[i]);
            }
          } else if (attrType.equals(Character.TYPE)) {
            if (attrValue.length() != 1) {
              throw new ADLException(
                "Bad char value: " + attrValue, (Node)attributes[i]);
            }
          } else if (attrType.equals(Short.TYPE)) {
            try {
              Short.valueOf(attrValue);
            } catch (NumberFormatException e) {
              throw new ADLException(
                "Bad short value: " + attrValue, (Node)attributes[i]);
            }
          } else if (attrType.equals(Boolean.TYPE)) {
            if (!attrValue.equals("true") && !attrValue.equals("false")) {
              throw new ADLException(
                "Bad boolean value: " + attrValue, (Node)attributes[i]);
            }
          } else {
            throw new ADLException("Unexpected case", (Node)attributes[i]);
          }
        } else if (attrType != String.class) {
          throw new ADLException(
            "Unsupported attribute type: " + attrType, (Node)attributes[i]);
        }
        */
      }
    }
  }
}
