/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.adl.implementations;

import java.util.HashMap;
import java.util.Map;

import org.objectweb.fractal.adl.implementations.ImplementationBuilder;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.util.Fractal;

import org.ow2.jasmine.jade.reflex.api.ReflexFractal;
import org.ow2.jasmine.jade.reflex.util.DebugReflex;
import org.ow2.jasmine.jade.reflex.util.Logger;
import org.ow2.jasmine.jade.reflex.util.Reflex;

/**
 * A reflexive Fractal based implementation of the {@link ImplementationBuilder} 
 * interface. This implementation uses the Reflex Fractal API to create 
 * reflexive components {@link org.ow2.jasmine.jade.reflex.api.ReflexFractal}. 
 *
 * @author <a href="mailto:fabienne.boyer@inrialpes.fr">Fabienne Boyer</a>
 */
public class ReflexFractalImplementationBuilder implements
        ImplementationBuilder {

    // -------------------------------------------------------------------------
    // Implementation of the ImplementationBuilder interface
    // -------------------------------------------------------------------------

    public Object createComponent(final Object type, final String name,
            final String definition, final Object controllerDesc,
            final Object contentDesc, final Object context) throws Exception {

        ClassLoader loader = null;
        if (context instanceof Map) {
            loader = (ClassLoader) ((Map) context).get("classloader");
        }

        Component bootstrap = null;
        if (context != null) {
            bootstrap = (Component) ((Map) context).get("bootstrap");
        }
        if (bootstrap == null) {
            if (loader != null) {
                Map ctxt = new HashMap();
                ctxt.put("classloader", loader);
                bootstrap = ReflexFractal.getBootstrapComponent(ctxt);
            } else {
                bootstrap = ReflexFractal.getBootstrapComponent();
            }
        }

        Logger.println(DebugReflex.genericfactory, "--------------------------------------------");
        Logger.println(DebugReflex.genericfactory,
                "[ReflexImplementationBuilder] createComponent : " + name);

        Component result = null;

        Boolean notif = Reflex.getReflexController(bootstrap).getIsNotifiable();

        if (notif) {

            result = Fractal.getGenericFactory(bootstrap).newFcInstance(
                    (ComponentType) type,
                    loader == null ? controllerDesc : new Object[] { loader,
                            controllerDesc }, contentDesc);

        } else {
            result = Reflex.getGenericInstallingFactoryNotification(bootstrap)
                    .newFcInstanceNotification(
                            (ComponentType) type,
                            loader == null ? controllerDesc : new Object[] {
                                    loader, controllerDesc }, contentDesc);
        }

        try {
            Fractal.getNameController(result).setFcName(name);
        } catch (NoSuchInterfaceException ignored) {
        }

        return result;
    }
}