/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.api;

import java.util.Map;

import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.factory.InstantiationException;

/**
 * Provides static methods to get a {@link org.objectweb.fractal.adl.Factory} component which 
 * operates in reflexive mode (the components created by this factory 
 * are reflexive components, which means that they are associated to a dual
 * component created by a dual factory). 
 * The name and the level (execution / meta) of the factory are given 
 * by the <tt>reflex-fractal.name</tt> and <tt>reflex-fractal.level</tt> system properties.
 * 
 * At instanciation time, the factory registrates itself under the naming service and
 * automatically get the reference of its dual factory if these has already been started.
 * 
 * @author <a href="mailto:fabienne.boyer@inrialpes.fr">Fabienne Boyer</a>
 */
public class ReflexFactoryFactory {

    public static String REFLEX_FRACTAL_BACKEND = "org.ow2.jasmine.jade.reflex.adl.ReflexFractalBackend";

    static Factory factory = null;

    /**
     * Returns a reflexive {@link Factory} with the given backend.
     * 
     * @param backend
     *            the desired backend.
     * @return a {@link Factory} with the given backend.
     * @throws ADLException
     *             if the factory cannot be created.
     */

    public static Factory getFactory(String backend) throws Exception {

        if (factory == null) {

            // Launching a Fractal reflexive bootstrap
            ReflexFractal.getBootstrapComponent();

            // create a factory with the ReflexFractalBackend
            // this backend uses the Fractal reflexive bootstrap to create
            // components
            factory = FactoryFactory.getFactory(getReflexBackend(backend));
        }
        return factory;
    }

    /**
     * Returns a reflexive {@link Factory} with the given implementation and
     * backend.
     * 
     * @param factory
     *            the name of the desired factory.
     * @param backend
     *            the desired backend.
     * @param context
     *            additional optional information.
     * @return a {@link Factory} with the given backend.
     * @throws ADLException
     *             if the factory cannot be created.
     * @throws InstantiationException 
     */
    public static Factory getFactory(final String fact,
            final String backend,
            final Map context) throws Exception{
        
//        context.put("backend", getReflexBackend(backend));
//        Factory f = FactoryFactory.getFactory();
//        Map c = (Map)f.newComponent(factory, context);
//        return (Factory)c.get("factory");
        
        if (factory == null) {

            // Launching a Fractal reflexive bootstrap
            ReflexFractal.getBootstrapComponent();

            // create a factory with the ReflexFractalBackend
            // this backend uses the Fractal reflexive bootstrap to create
            // components
            
            factory = FactoryFactory.getFactory(fact, getReflexBackend(backend), context);
            
        }
        return factory;
    }

    /**
     * Returns the reflexive backend corresponding to the given backend.
     * 
     * @param backend
     *            the desired backend.
     * @return the corresponding reflexive backend (null if not existing).
     */

    public static String getReflexBackend(String backend) {
        if (backend.equals(FactoryFactory.FRACTAL_BACKEND))
            return REFLEX_FRACTAL_BACKEND;
        else
            // no other existing reflexive backend
            return null;
    }
}
