/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.api.control;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;

/**
 * This interface is used to notify a binding update between the meta and the
 * exec level (and vice versa).
 * 
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 */
public interface BindingNotificationController {

	/**
	 * Binds the client interface whose name is given to a server interface.
	 * More precisely, binds the client interface of the component to which this
	 * interface belongs, and whose name is equal to the given name, to the
	 * given server interface. The given server interface must be in the same
	 * address space as the client interface.
	 * 
	 * @param clientItfName
	 *            the name of a client interface of the component to which this
	 *            interface belongs.
	 * @param serverItf
	 *            a server interface.
	 * @throws NoSuchInterfaceException
	 *             if there is no such client interface.
	 * @throws IllegalBindingException
	 *             if the binding cannot be created.
	 * @throws IllegalLifeCycleException
	 *             if this component has a {@link LifeCycleController}
	 *             interface, but it is not in an appropriate state to perform
	 *             this operation.
	 */

	void bindFcNotification(String clientItfName, Object serverItf)
			throws NoSuchInterfaceException, IllegalBindingException,
			IllegalLifeCycleException;

	/**
	 * Unbinds the given client interface. More precisely, unbinds the client
	 * interface of the component to which this interface belongs, and whose
	 * name is equal to the given name.
	 * 
	 * @param clientItfName
	 *            the name of a client interface of the component to which this
	 *            interface belongs.
	 * @throws NoSuchInterfaceException
	 *             if there is no such client interface.
	 * @throws IllegalBindingException
	 *             if the binding cannot be removed.
	 * @throws IllegalLifeCycleException
	 *             if this component has a {@link LifeCycleController}
	 *             interface, but it is not in an appropriate state to perform
	 *             this operation.
	 */

	void unbindFcNotification(String clientItfName)
			throws NoSuchInterfaceException, IllegalBindingException,
			IllegalLifeCycleException;
}
