/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.api.control;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;

/**
 * This interface is used to notify a content update between the meta and the
 * execution level (and vice versa).
 * 
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 */
public interface ContentNotificationController {

	/**
	 * Adds a sub-component to this component. More precisely adds the component
	 * whose reference is given as a sub-component of the component to which
	 * this interface belongs. If <i>C</i> is the sub-component set returned by
	 * {@link #getFcSubComponents getFcSubComponents} just before a call to this
	 * method, and <i>C'</i> is the sub-component set just after this call,
	 * then <tt>subComponent</tt> is guaranteed to be in <i>C'</i>, but <i>C'</i>
	 * is <i>not</i> guaranted to be the union of <i>C</i> and
	 * <i>{subComponent}</i>, nor to contain all the elements of <i>C</i>.
	 * 
	 * @param subComponent
	 *            the component to be added inside this component.
	 * @throws IllegalContentException
	 *             if the given component cannot be added inside this component.
	 * @throws IllegalLifeCycleException
	 *             if this component has a {@link LifeCycleController}
	 *             interface, but it is not in an appropriate state to perform
	 *             this operation.
	 */

	void addFcSubComponentNotification(Component subComponent)
			throws IllegalContentException, IllegalLifeCycleException;

	/**
	 * Removes a sub-component from this component. More precisely removes the
	 * sub-component whose reference is given from the component to which this
	 * interface belongs. If <i>C</i> is the sub-component set returned by
	 * {@link #getFcSubComponents getFcSubComponents} just before a call to this
	 * method, and <i>C'</i> is the sub-component set just after this call,
	 * then <tt>subComponent</tt> is guaranteed not to be in <i>C'</i>, but
	 * <i>C'</i> is <i>not</i> guaranted to be the difference of <i>C</i> and
	 * <i>{subComponent}</i>, nor to contain all the elements of <i>C</i>
	 * distinct from <tt>subComponent</tt>.
	 * 
	 * @param subComponent
	 *            the component to be removed from this component.
	 * @throws IllegalContentException
	 *             if the given component cannot be removed from this component.
	 * @throws IllegalLifeCycleException
	 *             if this component has a {@link LifeCycleController}
	 *             interface, but it is not in an appropriate state to perform
	 *             this operation.
	 */

	void removeFcSubComponentNotification(Component subComponent)
			throws IllegalContentException, IllegalLifeCycleException;
}
