/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.api.control;

import org.objectweb.fractal.api.Component;

/**
 * The meta controller interface defines getter/setter method to manage
 * component reference between the exec level and the metalevel.
 * 
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 * 
 * modified : 16/5/5 Fabienne Boyer add the following public attributes -
 * NO_LEVEL - EXEC_LEVEL - META_LEVEL add the following public methods : -
 * setLevel - getLevel
 */
public interface ReflexController {

	/**
	 * set the reference of the dual component : (reference of the associated
	 * component at the execution level if this component is at the meta level,
	 * reference of the associated component at the meta level if this component
	 * is at the execution level.
	 * 
	 * @param ref
	 *            the ref of the dual component
	 * 
	 */
	void setCmpRef(Component ref);

	/**
	 * return the reference of the dual component : (reference of the associated
	 * component at the execution level if this component is at the meta level,
	 * reference of the associated component at the meta level if this component
	 * is at the execution level.
	 * 
	 * @return the ref of the dual component
	 */
	Component getCmpRef();

	/**
	 * Each meta component created are added as sub component of the
	 * meta-component container
	 * 
	 * @param ref
	 *            the reference to the meta-component container
	 */
	void setMetaComponentContainer(Component ref);

	/**
	 * Each meta component created are added as sub component of the
	 * meta-component container
	 * 
	 * @return the reference to the meta-component container
	 */
	Component getMetaComponentContainer();

	/**
	 * Set a predefined reflex attribute.
	 * 
	 * @param name
	 *            the name of the attribute to set.
	 * @param value
	 *            the value of the attribute.
	 */
	void setReflexAttribute(String name, String value);

	/**
	 * Get a predefined reflex attribute.
	 * 
	 * @param name
	 *            the name of the attribute to set.
	 * @return the value of the attribute.
	 */
	String getReflexAttribute(String name);

	/**
	 * 
	 * @return
	 */
	boolean getIsNotifiable();

	/**
	 * 
	 * @param notifiable
	 */
	void setIsNotifiable(boolean notifiable);
}