/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.api.factory;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.deployment.local.api.PackageDescription;

/**
 * This interface is used to notify the creation of a component between the meta
 * and the exec level (and vice versa).
 * 
 * @author <a href="mailto:julien.legrand@inrialpes.fr">Julien Legrand</a>
 *
 */
public interface GenericInstallingFactoryNotification extends GenericFactoryNotification {
	
	/**
	 * Creates a {@link Component} given its type, a description of its control
	 * part (membrane), description of its content part (implementation) and a
	 * description of a package in which all those can be found
	 * 
	 * @param type
	 *            The {@link Type} of the {@link Component} to be created
	 * @param controllerDesc
	 *            A description of the controller part of a component.
	 *            Implementation specific
	 * @param contentDesc
	 *            A description of the content part of a component.
	 *            Implementation specific
	 * @param packageDescription
	 *            A description of the package containing the code of this
	 *            component. Implementation specific
	 * 
	 */
	public Component newFcInstanceNotification(Type type, Object controllerDesc,
			Object contentDesc, PackageDescription packageDescription)
			throws InstantiationException;

	/**
	 * Undeploys a given {@link Component}
	 * 
	 * @param cmp
	 *            A {@link Component} to be undeployed
	 */
	public void undeployFcComponentNotification(Component cmp);

}
