/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.control;

import java.util.HashMap;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.util.Fractal;

import org.ow2.jasmine.jade.reflex.api.control.ReflexController;
import org.ow2.jasmine.jade.reflex.util.DebugReflex;
import org.ow2.jasmine.jade.reflex.util.Logger;

/**
 * Provides a basic implementation of the {@link ReflexController}
 * ReflexController interface.
 * 
 * @author <a href="mailto:fabienne.boyer@inrialpes.fr">Fabienne Boyer</a>
 * 
 */
public abstract class BasicReflexControllerMixin implements Controller,
        ReflexController {

    // -------------------------------------------------------------------------
    // Private constructor
    // -------------------------------------------------------------------------

    private BasicReflexControllerMixin() {
    }

    // -------------------------------------------------------------------------
    // Fields and methods added and overriden by the mixin class
    // -------------------------------------------------------------------------

    /**
     * This field contains the reference to the dual component
     */
    Component cmp = null;

    /**
     * This field contains the reference to the component
     */
    Component metaComponentContainer = null;

    /**
     * The reflex attributes.
     */
    HashMap atts = null;
    
    /**
     * 
     */
    boolean isNotifiable;

    // ------------------------------------------------------------------------
    // Implementation of Controller interface
    // ------------------------------------------------------------------------

    /**
     * Initializes the fields of this mixin from the given context, and then
     * calls the overriden method.
     * 
     * @param ic
     *            information about the component to which this controller
     *            object belongs.
     * @throws InstantiationException
     *             if the initialization fails.
     */

    public void initFcController(final InitializationContext ic)
            throws InstantiationException {
        _super_initFcController(ic);
        isNotifiable = true;
    }

    // ------------------------------------------------------------------------
    // Implementation of ReflexController interface
    // ------------------------------------------------------------------------

    /**
     * set the reference of the dual component : (reference of the associated
     * component at the execution level if this component is at the meta level,
     * reference of the associated component at the meta level if this component
     * is at the execution level.
     * 
     * @param ref
     *            the ref of the dual component
     * 
     * @see org.ow2.jasmine.jade.reflex.ReflexController#setCmpRef(org.objectweb.fractal.api.Component)
     */
    public void setCmpRef(Component ref) {

        try {
        	
            Logger.println(DebugReflex.reflex,
                    "[ReflexController] setCmpRef : "
                            + ((Fractal.getNameController(ref).getFcName() == null) ? ref.toString() : Fractal.getNameController(ref).getFcName())
                            + " <-> "
                            + ((_this_weaveableOptNC.getFcName() == null) ? _this_weaveableC.toString() : _this_weaveableOptNC.getFcName()));
        } catch (NoSuchInterfaceException ignored) {
        }

        cmp = ref;
    }

    /**
     * return the reference of the dual component : (reference of the associated
     * component at the execution level if this component is at the meta level,
     * reference of the associated component at the meta level if this component
     * is at the execution level.
     * 
     * @return the ref of the dual component
     * @see org.ow2.jasmine.jade.reflex.ReflexController#getCmpRef()
     */

    public Component getCmpRef() {
        return cmp;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.jasmine.jade.reflex.api.control.ReflexController#setMetaComponentContainer(org.objectweb.fractal.api.Component)
     */
    public void setMetaComponentContainer(Component ref) {
        metaComponentContainer = ref;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.jasmine.jade.reflex.api.control.ReflexController#getMetaComponentContainer()
     */
    public Component getMetaComponentContainer() {
        return metaComponentContainer;
    }

    /**
     * Set a predefined reflex attribute .
     * 
     * @param name
     *            the name of the attribute to set.
     * @param value
     *            the value of the attribute.
     */
    public void setReflexAttribute(String name, String value) {
        if (atts == null)
            atts = new HashMap();
        if (value != null)
            atts.put(name, value);
    }

    /**
     * Get the value of a predefined reflex attribute .
     * 
     * @param name
     *            the name of the attribute to set.
     * @return the value of the attribute (null if it does not exist).
     */
    public String getReflexAttribute(String name) {
        return ((String) atts.get(name));
    }
    
    /* (non-Javadoc)
     * @see org.ow2.jasmine.jade.reflex.api.control.ReflexController#getIsNotifiable()
     */
    public boolean getIsNotifiable() {
        return isNotifiable;
    }

    /* (non-Javadoc)
     * @see org.ow2.jasmine.jade.reflex.api.control.ReflexController#setIsNotifiable(boolean)
     */
    public void setIsNotifiable(boolean notifiable) {
        isNotifiable = notifiable;
    }

    // -------------------------------------------------------------------------
    // Fields and methods required by the mixin class in the base class
    // -------------------------------------------------------------------------

    /**
     * The {@link Component} interface of the component to which this controller
     * object belongs.
     */
    public Component _this_weaveableC;
    
    /**
     * The {@link NameController} interface of the component to which this controller
     * object belongs.
     */
    public NameController _this_weaveableOptNC;

    /**
     * The {@link Controller#initFcController initFcController} method overriden
     * by this mixin.
     * 
     * @param ic
     *            information about the component to which this controller
     *            object belongs.
     * @throws InstantiationException
     *             if the initialization fails.
     */

    public abstract void _super_initFcController(InitializationContext ic)
            throws InstantiationException;

}
