/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.control;

import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;

import org.ow2.jasmine.jade.reflex.api.control.ReflexController;

/**
 * Provides a {@link ReflexController} field to a {@link Controller}. <br>
 * <br>
 * <b>Requirements</b>
 * <ul>
 * <li>the component to which this controller belongs must provide the {@link
 * ReflexController} interface.</li>
 * </ul>
 * 
 * @author <a href="mailto:fabienne.boyer@inrialpes.fr">Fabienne Boyer</a>
 * 
 */

public abstract class UseReflexControllerMixin implements Controller {

    // -------------------------------------------------------------------------
    // Private constructor
    // -------------------------------------------------------------------------

    private UseReflexControllerMixin() {
    }

    // -------------------------------------------------------------------------
    // Fields and methods added and overriden by the mixin class
    // -------------------------------------------------------------------------

    /**
     * The {@link ReflexController} interface of the component to which this
     * controller object belongs.
     */

    public ReflexController weaveableOptRC;

    /**
     * Initializes the fields of this mixin and then calls the overriden method.
     * 
     * @param ic
     *            information about the component to which this controller
     *            object belongs.
     * @throws InstantiationException
     *             if the initialization fails.
     */

    public void initFcController(final InitializationContext ic)
            throws InstantiationException {
        weaveableOptRC = (ReflexController) ic
                .getOptionalInterface("reflex-controller");
        _super_initFcController(ic);
    }

    // -------------------------------------------------------------------------
    // Fields and methods required by the mixin class in the base class
    // -------------------------------------------------------------------------

    /**
     * The {@link Controller#initFcController initFcController} method overriden
     * by this mixin.
     * 
     * @param ic
     *            information about the component to which this controller
     *            object belongs.
     * @throws InstantiationException
     *             if the initialization fails.
     */

    public abstract void _super_initFcController(InitializationContext ic)
            throws InstantiationException;

}
