/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.control.attribute;

import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;

import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;
import org.ow2.jasmine.jade.reflex.api.control.GenericAttributeNotificationController;
import org.ow2.jasmine.jade.reflex.api.control.ReflexController;
import org.ow2.jasmine.jade.reflex.util.DebugReflex;
import org.ow2.jasmine.jade.reflex.util.Logger;
import org.ow2.jasmine.jade.reflex.util.Reflex;

/**
 * Provide a basic implementation of the GenericAttributeController and
 * GenericAttributeControllerNotification. This mixin is used for component
 * which have an implementation. This mixin is used for example by jade
 * primitive component.
 * 
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 * 
 * Modified F. Boyer 1/6/5 Use _this_weaveableOptRC to get the ReflexController
 * of the current component
 */

public abstract class ReflexGenericAttributeControllerMixin implements
        GenericAttributeController, GenericAttributeNotificationController {

    private ReflexGenericAttributeControllerMixin() {
    }

    /**
     * Initializes the fields of this mixin and then calls the overriden method.
     * 
     * @param ic
     *            information about the component to which this controller
     *            object belongs.
     * @throws InstantiationException
     *             if the initialization fails.
     */

    public void initFcController(final InitializationContext ic)
            throws InstantiationException {
        _super_initFcController(ic);
    }

    // -------------------------------------------------------------------------
    // Fields and methods added and overriden by the mixin class
    // -------------------------------------------------------------------------

    /**
     * set the value of an attribute identified by its name and notify the
     * update to the dual level.
     * 
     * @param name
     *            the name of the attribute to read.
     * @param value
     *            the value of the attribute.
     * @throws NoSuchAttributeException
     *             if the given attribute is unknow.
     */
    public void setAttribute(String name, String value)
            throws NoSuchAttributeException {

        Logger.println(DebugReflex.attribute,
                "[GenericAttributeController] setAttribute : " + name + " = "
                        + value);

        _super_setAttribute(name, value);

        // notify the dual level
        if (_this_weaveableOptRC != null) {
            if (_this_weaveableOptRC.getIsNotifiable()) {

                try {
                    // get the attribute-notification-controller interface of
                    // the
                    // dual component
                    GenericAttributeNotificationController dualCtrl = Reflex
                            .getGenericAttributeNotificationController(_this_weaveableOptRC
                                    .getCmpRef());

                    dualCtrl.setAttributeNotification(name, value);
                } catch (Exception e) {
                    Logger
                            .println(DebugReflex.warning,
                                    "[Warning][GenericAttributeController] setAttribute : cannot update dual level");
                }
            }
        } else {
            Logger
                    .println(DebugReflex.warning,
                            "[Warning][GenericAttributeController] setAttribute : no dual level");
        }
    }

    /**
     * Set the value of an attribute identified by its name. This method is used
     * by the meta level to notify an attribute update.
     * 
     * @param name
     *            the name of the attribute to read.
     * @param value
     *            the value of the attribute.
     * @throws NoSuchAttributeException
     *             if the given attribute is unknow.
     */
    public void setAttributeNotification(String name, String value)
            throws NoSuchAttributeException {

        Logger.println(DebugReflex.attribute,
                "[Notification][GenericAttributeController] setAttribute : "
                        + name + " = " + value);

        _super_setAttribute(name, value);
    }

    // -------------------------------------------------------------------------
    // Fields and methods required by the mixin class in the base class
    // -------------------------------------------------------------------------
    /**
     * The <tt>weaveableOptRC</tt> field required by this mixin. This field is
     * supposed to reference the {@link ReflexController} interface of the
     * component to which this controller object belongs.
     */

    public ReflexController _this_weaveableOptRC;

    /**
     * The {@link Controller#initFcController initFcController} method overriden
     * by this mixin.
     */

    public abstract void _super_initFcController(InitializationContext ic)
            throws InstantiationException;

    /**
     * The {@link GenericAttributeController#setAttribute setAttribute} method
     * overriden by this mixin.
     */
    public abstract void _super_setAttribute(String name, String value);

}
