/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.control.name;

import org.objectweb.fractal.api.control.NameController;

import org.ow2.jasmine.jade.reflex.api.control.NameNotificationController;
import org.ow2.jasmine.jade.reflex.api.control.ReflexController;
import org.ow2.jasmine.jade.reflex.util.DebugReflex;
import org.ow2.jasmine.jade.reflex.util.Logger;
import org.ow2.jasmine.jade.reflex.util.Reflex;

/**
 * Provides an implementation of the
 * {@link org.objectweb.fractal.api.control.NameController} interface which
 * manages the causal connection with the dual level (i.e meta/execution) : Any
 * operation on the name of the current component is forwarded to the name
 * controller of dual component.
 * 
 * @author <a href="mailto:fabienne.boyer@inrialpes.fr">Fabienne Boyer</a>
 */

public abstract class ReflexNameMixin implements NameController,
        NameNotificationController {

    // -------------------------------------------------------------------------
    // Private constructor
    // -------------------------------------------------------------------------

    private ReflexNameMixin() {
    }

    // -------------------------------------------------------------------------
    // Fields and methods added and overriden by the mixin class
    // -------------------------------------------------------------------------

    /**
     * Calls the overriden setFcName method and then notifies the dual level of
     * the operation.
     * 
     * @param name
     *            the new component name
     */
    public void setFcName(final String name) {

        Logger.println(DebugReflex.name, "[NameController] setFcName : name = "
                + name);

        // calls the overriden setFcName method
        _super_setFcName(name);

        if (_this_weaveableOptRC != null) {
            if(_this_weaveableOptRC.getIsNotifiable()){
                try {
                    // get the name-notification-controller interface of the
                    // dual
                    // component
                    NameNotificationController dualCtrl = Reflex
                            .getNameNotificationController(_this_weaveableOptRC
                                    .getCmpRef());

                    // notify the dual level
                    dualCtrl.setFcNameNotification(name);
                } catch (Exception e) {
                    Logger
                            .println(DebugReflex.warning,
                                    "[Warning][NameController] setFcName : cannot update dual level");
                }
            }
        } else {
            Logger.println(DebugReflex.warning,
                    "[Warning][NameController] setFcName : no dual level");
        }
    }

    /**
     * Calls the overriden setFcName method
     * 
     * @param name
     *            the new component name
     */
    public void setFcNameNotification(String name) {

        Logger.println(DebugReflex.name,
                "[Notification][NameController] setFcName : name = " + name);

        // calls the overriden setFcName method
        _super_setFcName(name);

    }

    // -------------------------------------------------------------------------
    // Fields and methods required by the mixin class in the base class
    // -------------------------------------------------------------------------

    /**
     * The <tt>weaveableOptRC</tt> field required by this mixin. This field is
     * supposed to reference the {@link ReflexController} interface of the
     * component to which this controller object belongs.
     */

    public ReflexController _this_weaveableOptRC;

    /**
     * The {@link NameController#setFcName setFcName} method overriden by this
     * mixin.
     */

    public abstract void _super_setFcName(String name);

}
