/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.util;

import java.net.InetAddress;

import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.rmi.registry.Registry;

/**
 * Manipulation of environment variables for reflex-fractal
 * 
 * @author <a href="mailto:fabienne.boyer@inrialpes.fr">Fabienne Boyer</a>
 *
 */
public class Environment {

    /**
     * registry's node
     */
    public static final String registryNodeLabel = "registry.host";

    /**
     * registry's port
     */
    public static final String registryPortLabel = "registry.port";

    /**
     * name associated to the current Fractal instance
     */
    public static final String reflexNameLabel = "reflex-fractal.name";

    /**
     * reflexive level (execution / meta) associated to the current Fractal
     * instance
     */
    public static final String reflexLevelLabel = "reflex-fractal.level";

    /**
     * name associated to the dual Fractal instance
     */
    public static final String reflexDualNameLabel = "reflex-fractal.dual-name";

    /**
     * flag to indicate if you automate reflex service operations, like invoke
     * newFcInstanceNotification(...), setDual(...) in ReflexGenericFactoryMixin
     */
    public static final String reflexAuto = "reflex-fractal.auto";
    
    /**
     * flag to indicate if you automate reflex service operations, like invoke
     * newFcInstanceNotification(...), setDual(...) in ReflexGenericFactoryMixin
     */
    public static final String reflexNotify = "reflex-fractal.notify";

    /**
     * Get a property value
     * 
     * @param the
     *            property's name
     * @return the property's value (null if the property is undefined)
     */
    public static String getProperty(String propName) throws Exception {
        return System.getProperty(propName);
    }

    /**
     * Get the reference of the Registry
     * 
     * @return the reference of the registry (null if no registry is found)
     * @throws Exception
     *             if the registry's node or port are undefined in the
     *             environment
     */
    public static NamingService getRegistry() throws Exception {
        String registryNode;
        String registryPort;
        NamingService ns = null;

        // get the registry's host
        registryNode = getProperty(registryNodeLabel);
        if (registryNode == null) {
            registryNode = InetAddress.getLocalHost().getHostName(); 
        }

        // get the registry's port
        registryPort = getProperty(registryPortLabel);
        if (registryPort == null) {
            registryPort = new Integer(Registry.DEFAULT_PORT).toString();
        }

        try {
            ns = Registry.getRegistry(registryNode, new Integer(registryPort)
                    .intValue(), Environment.class.getClassLoader());
        } catch (Exception e) {
            Logger.println("Problem getting registry : " + e);
            return null;
        }
        return ns;
    }

}
