/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.util;

/**
 * @author F. Boyer 02/06/06 TODO: The monolog Logger should be used in the
 *         future
 */
public class Logger {

    // system property
    static final String REFLEXLOG = "reflex-fractal.debug";

    /**
     * print a trace to the logger
     * 
     * @param s
     */
    public static void print(String s) {
        try {
//            if (Environment.getProperty(REFLEXLOG) != null) {
                System.out.print(s);
//            }
        } catch (Exception e) {
            // nothing to do
        }
    }

    /**
     * print a nested exception in the logger
     * 
     * @param ex
     *            the exception to print
     */
    public static void print(Exception ex) {
        try {
//            if (Environment.getProperty(REFLEXLOG) != null) {
                printStackTrace(ex);
//            }
        } catch (Exception e) {
            // nothing to do
        }
    }

    /**
     * print a trace to the logger (with carriage return)
     * 
     * @param s
     */
    public static void println(String s) {
        try {
//            if (Environment.getProperty(REFLEXLOG) != null) {
                System.out.println(s);
//            }
        } catch (Exception e) {
            // nothing to do
        }
    }

    /**
     * Print a nested exception (with carriage return). Print all the nested
     * exception.
     * 
     * @param ex
     */
    public static void println(Exception ex) {
        try {
            printStackTrace(ex);
        } catch (Exception e) {
            // nothing to do
        }
    }

    public static void println(boolean level, String s) {
        try {
            if (level) {
                System.out.println(s);
            }
        } catch (Exception e) {
            // nothing to do
        }
    }

    public static void println(boolean level, Exception s) {
        try {
            if (level) {
                printStackTrace(s);
            }
        } catch (Exception e) {
            // nothing to do
        }
    }

    public static void printStackTrace(Exception e) {
        try {
            if (e != null) {
                StackTraceElement ste[] = e.getStackTrace();
                for (int i = 0; i < ste.length; i++)
                    println(ste[i].toString());
            }
        } catch (Exception ignored) {
        }
    }
}