/***
 * Reflex-Fractal
 *
 * Copyright (C) 2007 : INRIA - Domaine de Voluceau, Rocquencourt, B.P. 105, 
 * 78153 Le Chesnay Cedex - France 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: jade <AT> inrialpes <DOT> fr
 *
 * Author: SARDES project - http://sardes.inrialpes.fr
 *
 */
 
package org.ow2.jasmine.jade.reflex.util;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.util.Fractal;

/**
 * Provides utility methods to deal with Fractal components.
 * 
 * @author <a href="mailto:noel.depalma@inrialpes.fr">Noel de palma</a>
 * @author <a href="mailto:fabienne.boyer@inrialpes.fr">Fabienne Boyer</a>
 */
public class Util {
	
	/**
	 * utility method which search if a component has a direct subcomponent with a given name.
	 * @param cmp the component to inspect
	 * @param subcmpname the name of the subcomponent to search
	 * @return 	the reference of the subcomponent (null if not found) 
	 */
	public static Component search(Component cmp, String subcmpname){
		Component[] subcmp;
		String curName = null;
		try {		
			subcmp = (Fractal.getContentController(cmp)).getFcSubComponents();
			for (int i = 0; i<subcmp.length; i++){
				curName = (Fractal.getNameController(subcmp[i])).getFcName();
				if (subcmpname.equals(curName)) return subcmp[i];
			}
			return null;
			
		}catch (NoSuchInterfaceException e){
			return null;
		}    
	}
	
	/**
	 * utility method to find a subcomponent from a component root. 
	 * @param c the component root
	 * @param sub the full path name of the component to find.
	 * @return the component or null if the cmp is not found.
	 * 
	 * example : 
	 * if C0 has 3 subcmp : C1,C2,C3
	 * if C2 has 2 subcmp : C4,C5
	 * find(C0,"C4/C5") will return the ref of C5
	 */
	public static Component find(Component c,String sub) {
		int idx;
		String cmp = null;
		String newPath;
		Component subc = null;
		
		try {
			
			idx = sub.indexOf('/');
			if (idx != -1) {
				// find the cmp and follow the path
				cmp = sub.substring(0,idx);
				newPath = sub.substring(idx+1);
				subc = search(c,cmp);
				if (subc == null) return null;
				return find(subc,newPath);
			}else {
				// find the subcmp
				return search(c,sub);
			}
			
			
		}catch (Exception e){
			return null;
		}
	}
	
	
//	/**
//	* Test if the component passed as parameter has a client itf whose signature
//	* correspond to the signature passed as parameter.
//	* @param cmp the component to be tested
//	* @param signature the signature of the itf
//	* @return an array of interface object having this signature 
//	* (these interfaces are client/external) or null.  
//	*/
//	public static Interface[] getCmpItf(Component cmp, String signature)
//	{
//	Vector res = new Vector(10,10);
//	
//	Object[] itf = cmp.getFcInterfaces();
//	
//	if (itf!=null){
//	for (int i=0;i<itf.length;i++){
//	if (!(((InterfaceType)(((Interface) itf[i]).
//	getFcItfType())).isFcClientItf())){
//	
//	if (((InterfaceType)(((Interface) itf[i]).
//	getFcItfType())).getFcItfSignature()
//	.equals(signature)){
//	res.add(itf[i]);
//	
//	}
//	
//	}
//	}
//	return (Interface[]) res.toArray(new Interface[0]); 
//	} else return null;       
//	}
//	
//	

}
