/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.reflex.adl;

import java.util.Map;
import org.objectweb.deployment.scheduling.component.api.FactoryProviderTask;
import org.objectweb.deployment.scheduling.component.api.InstanceProviderTask;
import org.objectweb.deployment.scheduling.core.api.Scheduler;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.BasicTaskMap;
import org.objectweb.fractal.adl.Compiler;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.Loader;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.TaskMap;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.util.Fractal;
import org.ow2.jasmine.jade.reflex.api.ReflexFractal;
import org.ow2.jasmine.jade.reflex.api.control.ReflexController;
import org.ow2.jasmine.jade.reflex.util.Logger;
import org.ow2.jasmine.jade.reflex.util.Reflex;

public class ReflexBasicFactory
implements BindingController,
Factory {
    public static final String LOADER_BINDING = "loader";
    public static final String COMPILER_BINDING = "compiler";
    public static final String SCHEDULER_BINDING = "scheduler";
    public Loader loader;
    public Compiler compiler;
    public Scheduler scheduler;

    public String[] listFc() {
        return new String[]{LOADER_BINDING, COMPILER_BINDING, SCHEDULER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(LOADER_BINDING)) {
            return this.loader;
        }
        if (itf.equals(COMPILER_BINDING)) {
            return this.compiler;
        }
        if (itf.equals(SCHEDULER_BINDING)) {
            return this.scheduler;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(LOADER_BINDING)) {
            this.loader = (Loader)value;
        } else if (itf.equals(COMPILER_BINDING)) {
            this.compiler = (Compiler)value;
        } else if (itf.equals(SCHEDULER_BINDING)) {
            this.scheduler = (Scheduler)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(LOADER_BINDING)) {
            this.loader = null;
        } else if (itf.equals(COMPILER_BINDING)) {
            this.compiler = null;
        } else if (itf.equals(SCHEDULER_BINDING)) {
            this.scheduler = null;
        }
    }

    public Object newComponentType(String name, Map context) throws ADLException {
        Definition d = this.loader.load(name, context);
        BasicTaskMap m = new BasicTaskMap();
        this.compiler.compile(d, (TaskMap)m, context);
        try {
            m.getTask("type", (Object)d).execute((Object)context);
        }
        catch (Exception e) {
            Logger.println("Cannot execute the task: " + d.getName());
            Logger.println(e);
            throw new ADLException("Cannot execute the task: " + d.getName(), (Node)d, e);
        }
        return ((FactoryProviderTask)m.getTask("type", (Object)d)).getFactory();
    }

    public Object newComponent(String name, Map context) throws ADLException {
        Definition d = this.loader.load(name, context);
        BasicTaskMap m = new BasicTaskMap();
        this.compiler.compile(d, (TaskMap)m, context);
        this.scheduler.schedule(m.getTasks(), (Object)context);
        Component res = (Component)((InstanceProviderTask)m.getTask("create", (Object)d)).getInstance();
        Component bootstrap = null;
        if (context != null) {
            bootstrap = (Component)context.get("bootstrap");
        }
        if (bootstrap == null) {
            try {
                bootstrap = ReflexFractal.getBootstrapComponent();
            }
            catch (InstantiationException e) {
                Logger.println("Cannot get the reflexive bootstrap component");
                Logger.println((Exception)((Object)e));
                throw new ADLException("Cannot get the reflexive bootstrap component", (Node)d, (Exception)((Object)e));
            }
        }
        Component metaComponentContainer = null;
        try {
            ReflexController rc = Reflex.getReflexController(bootstrap);
            metaComponentContainer = Reflex.getReflexController(Reflex.getDualComponent(bootstrap)).getMetaComponentContainer();
        }
        catch (NoSuchInterfaceException e) {
            Logger.println("Cannot get the ReflexController");
            Logger.println((Exception)((Object)e));
            throw new ADLException("Cannot get the ReflexController", (Node)d, (Exception)((Object)e));
        }
        boolean isMeta = false;
        if (context.containsKey("meta")) {
            isMeta = (Boolean)context.get("meta");
        }
        Component metaRes = null;
        if (isMeta) {
            metaRes = res;
        } else {
            try {
                metaRes = Reflex.getReflexController(res).getCmpRef();
            }
            catch (NoSuchInterfaceException e) {
                Logger.println("Cannot get the ReflexController");
                Logger.println((Exception)((Object)e));
                throw new ADLException("Cannot get the ReflexController", (Node)d, (Exception)((Object)e));
            }
        }
        if (metaComponentContainer != null && metaRes != null) {
            try {
                Fractal.getContentController((Component)metaComponentContainer).addFcSubComponent(metaRes);
            }
            catch (Exception e) {
                Logger.println("Cannot add the ref of the meta component to the meta component of bootstrap");
                Logger.println(e);
                throw new ADLException("Cannot add the ref of the meta component to the meta component of bootstrap", (Node)d, e);
            }
        }
        return res;
    }
}

