/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.reflex.adl.attributes;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.attributes.Attribute;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentDefinition;

public class ReflexFractalAttributeLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        boolean extend = false;
        if (d instanceof ComponentDefinition) {
            extend = ((ComponentDefinition)d).getExtends() != null;
        }
        this.checkNode(d, extend);
        return d;
    }

    private void checkNode(Object node, boolean extend) throws ADLException {
        if (node instanceof AttributesContainer) {
            this.checkAttributesContainer((AttributesContainer)node, extend);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i], extend);
            }
        }
    }

    private void checkAttributesContainer(AttributesContainer container, boolean extend) throws ADLException {
        Attributes attrs = container.getAttributes();
        if (attrs != null) {
            String signature = attrs.getSignature();
            if (signature == null) {
                if (!extend) {
                    throw new ADLException("Signature missing", (Node)attrs);
                }
                return;
            }
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            try {
                cl.loadClass(signature);
            }
            catch (ClassNotFoundException e) {
                throw new ADLException("Invalid signature '" + signature + "'", (Node)attrs, (Exception)e);
            }
            Attribute[] attributes = attrs.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                String attrName = attributes[i].getName();
                String attrValue = attributes[i].getValue();
                if (attrName == null) {
                    throw new ADLException("Attribute name missing", (Node)attributes[i]);
                }
                if (attrValue != null) continue;
                throw new ADLException("Attribute value missing", (Node)attributes[i]);
            }
        }
    }
}

