/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.resource.start;

import java.util.HashSet;
import java.util.LinkedHashMap;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.resource.Resource;
import org.objectweb.jasmine.jade.service.Service;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.jasmine.jade.util.Logger;

public class Start
implements Service,
BindingController {
    static final String RSRC_PREFIX = "rsrc";
    private LinkedHashMap<String, Object> rsrcRef = new LinkedHashMap();
    private Component myself;

    public String[] listFc() {
        HashSet<String> keys = new HashSet<String>(this.rsrcRef.keySet());
        return keys.toArray(new String[keys.size()]);
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.startsWith(RSRC_PREFIX)) {
            return this.rsrcRef.get(itfName);
        }
        if (itfName.equals("component")) {
            return this.myself;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.startsWith(RSRC_PREFIX)) {
            this.rsrcRef.put(itfName, itfValue);
        } else if (itfName.equals("component")) {
            this.myself = (Component)itfValue;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.startsWith(RSRC_PREFIX)) {
            this.rsrcRef.remove(itfName);
        } else if (itfName.equals("component")) {
            this.myself = null;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public void start() throws JadeException {
        String resourceName = "";
        try {
            Component[] supers = Fractal.getSuperController((Component)this.myself).getFcSuperComponents();
            resourceName = Fractal.getNameController((Component)supers[0]).getFcName();
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        Logger.println(true, "[Start] Resource \"" + resourceName + "\" starting ...");
        try {
            for (String rname : this.rsrcRef.keySet()) {
                Logger.println(true, "[Start] resource : " + rname.replaceAll("rsrc_", ""));
                Resource r = (Resource)this.rsrcRef.get(rname);
                Logger.println(true, "[Start] configure ...");
                r.configure();
                Logger.println(true, "[Start] loadApp ...");
                r.loadApp();
                Logger.println(true, "[Start] start ...");
                r.start();
            }
            Logger.println(true, "[Start] Resource started");
        }
        catch (Exception e) {
            throw new JadeException("[Start] Can't start resource \"" + resourceName + "\"", e);
        }
    }

    public void stop() throws JadeException {
        String resourceName = "";
        try {
            Component[] supers = Fractal.getSuperController((Component)this.myself).getFcSuperComponents();
            resourceName = Fractal.getNameController((Component)supers[0]).getFcName();
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        Logger.println(true, "[Start] Resource \"" + resourceName + "\" stopping ...");
        try {
            for (String rname : this.rsrcRef.keySet()) {
                Logger.println(true, "[Start] resource : " + rname);
                Resource r = (Resource)this.rsrcRef.get(rname);
                Logger.println(true, "[Start] stop ...");
                r.stop();
            }
            Logger.println(true, "[Start] Resource stopped");
        }
        catch (Exception e) {
            throw new JadeException("[Start] Can't stop resource \"" + resourceName + "\"", e);
        }
    }
}

