/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.gc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.deployment.local.api.GarbageCollector;
import org.objectweb.fractal.deployment.local.api.Installer;
import org.objectweb.fractal.deployment.local.api.LocallyInstalledPackage;

public class GarbageCollectorImpl
implements GarbageCollector,
BindingController {
    private final String INSTALLER_ITF = "installer";
    private Map<Component, LocallyInstalledPackage> cmpsToPkgs = new HashMap<Component, LocallyInstalledPackage>();
    private Installer installer = null;

    public synchronized void notifyComponentCreated(Component comp, LocallyInstalledPackage pkg) {
        this.cmpsToPkgs.put(comp, pkg);
    }

    public synchronized void notifyComponentDestroyed(Component comp) {
        List dependencies;
        LocallyInstalledPackage cmpPkg = this.cmpsToPkgs.get(comp);
        if (cmpPkg == null) {
            return;
        }
        cmpPkg.decreaseReferenceCounter();
        if (cmpPkg.getReferenceCounter() < 1 && !cmpPkg.isMarked()) {
            try {
                this.installer.uninstall(cmpPkg);
                System.out.println("[IGC] garbage collecting the package '" + cmpPkg.getPackageDescription().getPackageID() + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((dependencies = cmpPkg.getDependencies()) != null) {
            for (LocallyInstalledPackage dependency : dependencies) {
                dependency.decreaseReferenceCounter();
                if (dependency.getReferenceCounter() >= 1 || dependency.isMarked()) continue;
                System.out.println("[IGC] garbage collecting the dependent package '" + dependency + "'");
                try {
                    this.installer.uninstall(dependency);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.cmpsToPkgs.remove(comp);
    }

    public void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (clientItfName.equals(this.INSTALLER_ITF)) {
            this.installer = (Installer)serverItf;
        }
    }

    public String[] listFc() {
        return new String[]{this.INSTALLER_ITF};
    }

    public Object lookupFc(String clientItfName) throws NoSuchInterfaceException {
        if (clientItfName.equals(this.INSTALLER_ITF)) {
            return this.installer;
        }
        return null;
    }

    public void unbindFc(String clientItfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (clientItfName.equals(this.INSTALLER_ITF)) {
            this.installer = null;
        }
    }
}

