/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.heartbeat;

import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.jasmine.jade.util.Logger;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;

public abstract class AbstractHeartBeat
implements LifeCycleController,
GenericAttributeController,
Runnable {
    private boolean started = false;
    private boolean firstStart = true;
    private Thread thread;
    static final String[] attList = new String[]{"pulsePeriodInSec", "discoveryHost", "discoveryPort", "nodeName"};
    protected String pulsePeriodInSec = "2";
    protected String discoveryHost = "localhost";
    protected String discoveryPort = "9998";
    protected String nodeName = "PULSE";

    protected abstract void init() throws Exception;

    protected abstract void pulse() throws Exception;

    public String getFcState() {
        if (this.started) {
            return "STARTED";
        }
        return "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        if (this.firstStart) {
            try {
                this.init();
                this.firstStart = false;
            }
            catch (Exception e) {
                throw new IllegalLifeCycleException("[Hearbeat] Unable to start the component : error during connection to discovery service");
            }
        }
        if (!this.started) {
            this.started = true;
            this.thread = new Thread((Runnable)this, "HeartBeat");
            this.thread.setDaemon(true);
            this.thread.start();
            Logger.println(true, "[Heartbeat] started");
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (this.started) {
            this.started = false;
            this.thread.interrupt();
            Logger.println(true, "[Heartbeat] stopped");
        }
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if (name.equals("pulsePeriodInSec")) {
            return this.pulsePeriodInSec;
        }
        if (name.equals("discoveryHost")) {
            return this.discoveryHost;
        }
        if (name.equals("discoveryPort")) {
            return this.discoveryPort;
        }
        if (name.equals("nodeName")) {
            return this.nodeName;
        }
        throw new NoSuchAttributeException(name);
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (name.equals("pulsePeriodInSec")) {
            this.pulsePeriodInSec = value;
        } else if (name.equals("discoveryHost")) {
            this.discoveryHost = value;
        } else if (name.equals("discoveryPort")) {
            this.discoveryPort = value;
        } else if (name.equals("nodeName")) {
            this.nodeName = value;
        } else {
            throw new NoSuchAttributeException(name);
        }
    }

    public String[] listFcAtt() {
        return attList;
    }

    public void run() {
        while (this.started && !this.thread.isInterrupted()) {
            try {
                try {
                    this.pulse();
                }
                catch (Exception e) {
                    Logger.println("[HeartBeat] Error during sending heartbeat : " + e.getLocalizedMessage());
                }
                Thread.sleep(new Integer(this.pulsePeriodInSec) * 1000);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

