/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.osgi;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.osgi.framework.BundleContext;

public class JadeProperties {
    private static JadeProperties singleton;
    private static InetAddress defaultInetAddress;
    private static boolean isJadeInReflexMode;
    private static boolean isJadeInAutoReflexMode;
    private static String jadeReflexName;
    private static String jadeReflexDualname;
    private static String jadeRegistryHost;
    private static String jadeRegistryPort;
    private static String jadeDiscoveryHost;
    private static String jadeDiscoveryPort;
    private static String jadeJndiPort;
    private static String jadeUrlsDeployableFile;
    private static String jadeHeartbeatPulse;
    private static String clifCodeServerHost;
    private static String clifCodeServerPort;
    private static String jadeNodeName;
    private static boolean isJMXAgentEnabled;
    private static final String DEFAULT_JADE_REGISTRY_PORT;
    private static final String DEFAULT_JADE_DISCOVERY_PORT = "9998";
    private static final String DEFAULT_JADE_JNDI_PORT = "1239";
    private static final String DEFAULT_JADE_URLS_DEPLOYABLE_FILE = "http://proton.inrialpes.fr/~jlegrand/jade/examples/";
    private static final String DEFAULT_JADE_HEARTBEAT_PULSE = "3";
    private static final String DEFAULT_CLIF_CODE_SERVER_PORT = "1357";
    private final String systemRepresentationName = "system_representation";
    private final String jadePlatformName = "jade_platform";
    private static final String FDF_UNDEFINED_VALUE = "UNDEFINED";
    public static final String JADE_BOOT = "org.ow2.jasmine.jade.fractal.adl.JadeFactory";
    public static final String JADE_BOOT_REFLEX = "org.ow2.jasmine.jade.fractal.adl.JadeFactory";
    public static final String BOOT_BACKEND = "org.ow2.jasmine.jade.fractal.adl.BootBackend";
    public static final String BOOT_BACKEND_REFLEX = "org.objectweb.fractal.adl.FractalBackend";
    public static final String JADE_BOOT_ADL = "org.objectweb.jasmine.jade.boot.jadeboot.JadeBoot";
    public static final String JADE_NODE_ADL = "org.objectweb.jasmine.jade.boot.jadenode.JadeNode";
    private static final String JULIA_LOADER = "org.objectweb.fractal.julia.loader.DynamicLoader";
    private static final String FRACTAL_PROVIDER = "org.ow2.jasmine.jade.fractal.julia.JuliaJade";
    private static final String FRACTAL_PROVIDER_REFLEX = "org.ow2.jasmine.jade.reflex.util.ReflexJulia";
    private static final String JULIA_CONFIG = "etc/julia.cfg,etc/julia-fractal-rmi.cfg,etc/julia-jade.cfg,etc/julia-deploy.cfg";
    private static final String JULIA_CONFIG_REFLEX = "etc/julia.cfg,etc/julia-fractal-rmi.cfg,etc/julia-jade.cfg,etc/julia-deploy.cfg,etc/reflex-julia.cfg,etc/reflex-julia-jade.cfg,etc/reflex-julia-deploy.cfg";
    private static final String JULIA_LOADER_USE_CONTEXT_CLASS_LOADER = "false";
    private static final String JAVA_SECURITY_POLICY = "etc/java.policy";

    public JadeProperties() {
    }

    public JadeProperties(BundleContext context) {
        JadeProperties.processBundleContext(context);
    }

    public static synchronized JadeProperties getInstance() {
        if (singleton == null) {
            singleton = new JadeProperties();
        }
        return singleton;
    }

    public static synchronized JadeProperties getInstance(BundleContext context) {
        if (singleton == null) {
            singleton = new JadeProperties(context);
        } else {
            JadeProperties.processBundleContext(context);
        }
        return singleton;
    }

    public String getJadeDiscoveryHost() {
        return jadeDiscoveryHost;
    }

    public String getJadeDiscoveryPort() {
        return jadeDiscoveryPort;
    }

    public String getJadeHeartbeatPulse() {
        return jadeHeartbeatPulse;
    }

    public String getJadeJndiPort() {
        return jadeJndiPort;
    }

    public boolean isJadeReflex() {
        return isJadeInReflexMode;
    }

    public boolean isJadeReflexAuto() {
        return isJadeInAutoReflexMode;
    }

    public String getJadeReflexDualname() {
        return jadeReflexDualname;
    }

    public String getJadeReflexName() {
        return jadeReflexName;
    }

    public String getJadeRegistryHost() {
        return jadeRegistryHost;
    }

    public String getJadeRegistryPort() {
        return jadeRegistryPort;
    }

    public String getJadeUrlsDeployableFile() {
        return jadeUrlsDeployableFile;
    }

    public InetAddress getDefaultInetAddress() {
        return defaultInetAddress;
    }

    public String getSystemRepresentationName() {
        return "system_representation";
    }

    public String getJadePlatformName() {
        return "jade_platform";
    }

    public String getJadeNodeName() {
        return jadeNodeName;
    }

    public void setJadeNodeName(String jadeNodeName) {
        JadeProperties.jadeNodeName = jadeNodeName;
    }

    public String getClifCodeServerHost() {
        return clifCodeServerHost;
    }

    public String getClifCodeServerPort() {
        return clifCodeServerPort;
    }

    public boolean isJMXAgentEnabled() {
        return isJMXAgentEnabled;
    }

    private static void processBundleContext(BundleContext context) {
        String property = null;
        property = context.getProperty("julia.loader");
        if (property != null) {
            System.setProperty("julia.loader", property);
        } else {
            System.setProperty("julia.loader", JULIA_LOADER);
        }
        property = null;
        property = context.getProperty("java.security.policy");
        if (property != null) {
            System.setProperty("java.security.policy", property);
        } else {
            System.setProperty("java.security.policy", JAVA_SECURITY_POLICY);
        }
        property = null;
        property = context.getProperty("julia.loader.use-context-class-loader");
        if (property != null) {
            System.setProperty("julia.loader.use-context-class-loader", property);
        } else {
            System.setProperty("julia.loader.use-context-class-loader", JULIA_LOADER_USE_CONTEXT_CLASS_LOADER);
        }
        jadeRegistryHost = context.getProperty("jadeboot.registry.host");
        if (jadeRegistryHost == null || FDF_UNDEFINED_VALUE.equals(jadeRegistryHost) || !JadeProperties.isValidHost(jadeRegistryHost)) {
            jadeRegistryHost = defaultInetAddress.getHostAddress();
        }
        if ((jadeRegistryPort = context.getProperty("jadeboot.registry.port")) == null || FDF_UNDEFINED_VALUE.equals(jadeRegistryPort)) {
            jadeRegistryPort = DEFAULT_JADE_REGISTRY_PORT;
        }
        System.setProperty("registry.host", jadeRegistryHost);
        System.setProperty("registry.port", new Integer(jadeRegistryPort).toString());
        jadeDiscoveryHost = context.getProperty("jadeboot.discovery.host");
        if (jadeDiscoveryHost == null || FDF_UNDEFINED_VALUE.equals(jadeDiscoveryHost) || !JadeProperties.isValidHost(jadeDiscoveryHost)) {
            jadeDiscoveryHost = defaultInetAddress.getHostAddress();
        }
        if ((jadeDiscoveryPort = context.getProperty("jadeboot.discovery.port")) == null || FDF_UNDEFINED_VALUE.equals(jadeDiscoveryPort)) {
            jadeDiscoveryPort = DEFAULT_JADE_DISCOVERY_PORT;
        }
        if ((jadeJndiPort = context.getProperty("jadeboot.jndi.port")) == null || FDF_UNDEFINED_VALUE.equals(jadeJndiPort)) {
            jadeJndiPort = DEFAULT_JADE_JNDI_PORT;
        }
        if ((jadeHeartbeatPulse = context.getProperty("jadenode.heartbeat.pulse")) == null || FDF_UNDEFINED_VALUE.equals(jadeHeartbeatPulse)) {
            jadeHeartbeatPulse = DEFAULT_JADE_HEARTBEAT_PULSE;
        }
        if ((jadeUrlsDeployableFile = context.getProperty("jadeboot.urls.deployable.file")) == null || FDF_UNDEFINED_VALUE.equals(jadeUrlsDeployableFile)) {
            jadeUrlsDeployableFile = DEFAULT_JADE_URLS_DEPLOYABLE_FILE;
        }
        property = null;
        property = context.getProperty("jade.reflex");
        if (property != null) {
            isJadeInReflexMode = Boolean.parseBoolean(property);
        }
        property = null;
        property = context.getProperty("jadeboot.jmx.enabled");
        if (property != null) {
            isJMXAgentEnabled = Boolean.parseBoolean(property);
        }
        if (isJadeInReflexMode) {
            property = null;
            property = context.getProperty("jade.reflex.name");
            if (property != null && !FDF_UNDEFINED_VALUE.equals(property)) {
                System.setProperty("reflex-fractal.name", property);
            }
            property = null;
            property = context.getProperty("jade.reflex.dual-name");
            if (property != null && !FDF_UNDEFINED_VALUE.equals(property)) {
                System.setProperty("reflex-fractal.dual-name", property);
            }
            property = null;
            property = context.getProperty("jade.reflex.auto");
            if (property == null || FDF_UNDEFINED_VALUE.equals(property)) {
                System.setProperty("reflex-fractal.auto", "true");
            } else {
                System.setProperty("reflex-fractal.auto", property);
            }
        }
        property = null;
        property = context.getProperty("julia.config");
        if (property != null) {
            System.setProperty("julia.config", property);
        } else if (isJadeInReflexMode) {
            System.setProperty("julia.config", JULIA_CONFIG_REFLEX);
        } else {
            System.setProperty("julia.config", JULIA_CONFIG);
        }
        property = null;
        property = context.getProperty("fractal.provider");
        if (property != null) {
            System.setProperty("fractal.provider", property);
        } else if (isJadeInReflexMode) {
            System.setProperty("fractal.provider", FRACTAL_PROVIDER_REFLEX);
        } else {
            System.setProperty("fractal.provider", FRACTAL_PROVIDER);
        }
        clifCodeServerHost = context.getProperty("clif.codeserver.host");
        if (clifCodeServerHost == null || FDF_UNDEFINED_VALUE.equals(clifCodeServerHost) || !JadeProperties.isValidHost(clifCodeServerHost)) {
            clifCodeServerHost = defaultInetAddress.getHostAddress();
        }
        if ((clifCodeServerPort = context.getProperty("clif.codeserver.port")) == null || FDF_UNDEFINED_VALUE.equals(clifCodeServerPort)) {
            clifCodeServerPort = DEFAULT_CLIF_CODE_SERVER_PORT;
        }
    }

    private static boolean isValidHost(String host) {
        if (host != null && host.indexOf(47) == -1) {
            try {
                Inet4Address.getByName(host);
                return true;
            }
            catch (UnknownHostException ignored) {
                return false;
            }
        }
        return false;
    }

    static {
        defaultInetAddress = null;
        isJadeInReflexMode = true;
        isJadeInAutoReflexMode = true;
        jadeReflexName = null;
        jadeReflexDualname = null;
        jadeRegistryHost = null;
        jadeDiscoveryHost = null;
        jadeDiscoveryPort = null;
        jadeUrlsDeployableFile = null;
        jadeHeartbeatPulse = null;
        clifCodeServerHost = null;
        clifCodeServerPort = null;
        isJMXAgentEnabled = true;
        DEFAULT_JADE_REGISTRY_PORT = new Integer(1234).toString();
        InetAddress default_localhost = null;
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements() && (default_localhost == null || default_localhost.isLoopbackAddress())) {
                Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                while (addresses.hasMoreElements() && (default_localhost == null || default_localhost.isLoopbackAddress())) {
                    InetAddress address = addresses.nextElement();
                    if (address instanceof Inet6Address) continue;
                    default_localhost = address;
                }
            }
        }
        catch (SocketException ignored) {
            // empty catch block
        }
        if (default_localhost == null) {
            try {
                default_localhost = InetAddress.getByName(null);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        defaultInetAddress = default_localhost;
    }
}

