/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.cleaner;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.NamingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.jasmine.jade.service.jms.JMSController;

public class RegistryCleanerImpl
implements LifeCycleController,
BindingController {
    private boolean started = false;
    private NamingService registry;
    private JMSController jms;
    private Context jmsJndi;
    private TopicConnection topicConnection = null;
    private TopicSession topicSession = null;
    private static final String FAILED_NODE_TOPIC_NAME = "FailedNodeTopic";

    public String getFcState() {
        if (this.started) {
            return "STARTED";
        }
        return "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.subscribeJmsTopic();
        }
        catch (JMSException e) {
            throw new IllegalLifeCycleException("The registry cleaner can't subscribe to Joram topics");
        }
        this.started = true;
        System.out.println("[Registry cleaner] started");
    }

    public void stopFc() throws IllegalLifeCycleException {
        this.started = false;
        System.out.println("[Registry cleaner] stopped");
    }

    public void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("Component Started");
        }
        if (clientItfName.equals("registry")) {
            this.registry = (NamingService)serverItf;
        } else if (clientItfName.equals("jms")) {
            this.jms = (JMSController)serverItf;
        } else if (clientItfName.equals("jmsJndi")) {
            this.jmsJndi = (Context)serverItf;
        } else {
            throw new NoSuchInterfaceException(clientItfName);
        }
    }

    public String[] listFc() {
        return new String[]{"registry", "jms", "jmsJndi"};
    }

    public Object lookupFc(String clientItfName) throws NoSuchInterfaceException {
        if (clientItfName.equals("registry")) {
            return this.registry;
        }
        if (clientItfName.equals("jms")) {
            return this.jms;
        }
        if (clientItfName.equals("jmsJndi")) {
            return this.jmsJndi;
        }
        throw new NoSuchInterfaceException(clientItfName);
    }

    public void unbindFc(String clientItfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("Component Started");
        }
        if (clientItfName.equals("registry")) {
            this.registry = null;
        } else if (clientItfName.equals("jms")) {
            this.jms = null;
        } else if (clientItfName.equals("jmsJndi")) {
            this.jmsJndi = null;
        } else {
            throw new NoSuchInterfaceException(clientItfName);
        }
    }

    private void subscribeJmsTopic() throws JMSException {
        Topic failedNodeTopic = null;
        boolean lookup = false;
        while (!lookup) {
            try {
                failedNodeTopic = (Topic)this.jmsJndi.lookup(FAILED_NODE_TOPIC_NAME);
                lookup = true;
            }
            catch (NamingException ignored) {}
        }
        this.topicConnection = (TopicConnection)this.jms.getTopicConnection();
        this.topicSession = this.topicConnection.createTopicSession(true, 1);
        TopicSubscriber failedNodeSubscriber = this.topicSession.createSubscriber(failedNodeTopic);
        failedNodeSubscriber.setMessageListener((MessageListener)new FailedNodeMsgListener());
        this.topicConnection.start();
    }

    private void unsubscribeJmstopic() {
        try {
            this.topicSession.unsubscribe(FAILED_NODE_TOPIC_NAME);
            this.topicConnection.close();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    class FailedNodeMsgListener
    implements MessageListener {
        FailedNodeMsgListener() {
        }

        public void onMessage(Message msg) {
            if (msg instanceof TextMessage) {
                try {
                    String failedNode = ((TextMessage)msg).getText();
                    System.out.println("[Registry cleaner] failed JadeNode detected : " + failedNode);
                    this.clean(failedNode);
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void clean(String failedNode) throws IllegalContentException, IllegalLifeCycleException, NoSuchInterfaceException {
            System.out.println("[Registry cleaner] starting ...");
            RegistryCleanerImpl.this.registry.unbind(failedNode);
            System.out.println("[Registry cleaner] done ");
        }
    }
}

