/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.deployer.adl.bindings;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.deployment.scheduling.component.api.InstanceProviderTask;
import org.objectweb.deployment.scheduling.component.lib.AbstractRequireInstanceProviderTask;
import org.objectweb.deployment.scheduling.core.api.Task;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.TaskMap;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingBuilder;
import org.objectweb.fractal.adl.bindings.BindingContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentPair;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.api.control.BindingController;

public class BindingCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public BindingBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (BindingBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        Task virtualNodeCleanTask = tasks.getTask("cleanNodes", (Object)"beurk");
        HashMap<String, Object> subComponents = new HashMap<String, Object>();
        subComponents.put("this", container);
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            subComponents.put(comps[i].getName(), comps[i]);
        }
        if (container instanceof BindingContainer) {
            Binding[] bindings = ((BindingContainer)container).getBindings();
            for (int i = 0; i < bindings.length; ++i) {
                Binding binding = bindings[i];
                String value = binding.getFrom();
                int index = value.indexOf(46);
                Object clientComp = subComponents.get(value.substring(0, index));
                String clientItf = value.substring(index + 1);
                value = binding.getTo();
                index = value.indexOf(46);
                Object serverComp = subComponents.get(value.substring(0, index));
                String serverItf = value.substring(index + 1);
                InstanceProviderTask createClientTask = (InstanceProviderTask)tasks.getTask("create", clientComp);
                InstanceProviderTask createServerTask = (InstanceProviderTask)tasks.getTask("create", serverComp);
                int type = 0;
                if (binding.getFrom().startsWith("this.")) {
                    type = 1;
                }
                if (binding.getTo().startsWith("this.")) {
                    type = 2;
                }
                try {
                    tasks.getTask("bind" + clientItf, clientComp);
                    continue;
                }
                catch (NoSuchElementException e) {
                    Task addTask;
                    BindTask bindTask = new BindTask(this.builder, type, clientItf, serverItf);
                    bindTask.setInstanceProviderTask(createClientTask);
                    bindTask.setServerInstanceProviderTask(createServerTask);
                    tasks.addTask("bind" + clientItf, clientComp, (Task)bindTask);
                    if (clientComp != container) {
                        addTask = tasks.getTask("add", (Object)new ComponentPair(container, (Component)clientComp));
                        bindTask.addPreviousTask(addTask);
                    }
                    if (serverComp != container) {
                        addTask = tasks.getTask("add", (Object)new ComponentPair(container, (Component)serverComp));
                        bindTask.addPreviousTask(addTask);
                    }
                    virtualNodeCleanTask.addPreviousTask((Task)bindTask);
                    Task startTask = tasks.getTask("start", clientComp);
                    startTask.addPreviousTask((Task)bindTask);
                }
            }
        }
    }

    static class BindTask
    extends AbstractRequireInstanceProviderTask {
        private InstanceProviderTask serverInstanceProviderTask;
        private BindingBuilder builder;
        private int type;
        private String clientItf;
        private String serverItf;

        public BindTask(BindingBuilder builder, int type, String clientItf, String serverItf) {
            this.builder = builder;
            this.type = type;
            this.clientItf = clientItf;
            this.serverItf = serverItf;
        }

        public InstanceProviderTask getServerInstanceProviderTask() {
            return this.serverInstanceProviderTask;
        }

        public void setServerInstanceProviderTask(InstanceProviderTask task) {
            if (this.serverInstanceProviderTask != null) {
                this.removePreviousTask((Task)this.serverInstanceProviderTask);
            }
            this.serverInstanceProviderTask = task;
            if (this.serverInstanceProviderTask != null) {
                this.addPreviousTask((Task)this.serverInstanceProviderTask);
            }
        }

        public void execute(Object context) throws Exception {
            Object client = this.getInstanceProviderTask().getInstance();
            Object server = this.getServerInstanceProviderTask().getInstance();
            this.builder.bindComponent(this.type, client, this.clientItf, server, this.serverItf, context);
        }

        public Object getResult() {
            return null;
        }

        public void setResult(Object result) {
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[BindTask(" + this.clientItf + "," + this.serverItf + ")]";
        }
    }
}

