/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.deployer.adl.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.jasmine.jade.service.allocator.Allocator;
import org.objectweb.jasmine.jade.service.deployer.adl.nodes.VirtualNode;
import org.objectweb.jasmine.jade.service.deployer.adl.nodes.VirtualNodeContainer;

public class VirtualNodeLoader
extends AbstractLoader
implements BindingController {
    private Map<String, String> nodes = new HashMap<String, String>();
    private Allocator allocator;

    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d);
        this.checkVirtualNodeNumber();
        return d;
    }

    private void checkNode(Object node) throws ADLException {
        VirtualNodeContainer virtualNodeContainer;
        if (node instanceof VirtualNodeContainer && (virtualNodeContainer = (VirtualNodeContainer)node) != null) {
            VirtualNode virtualNode = virtualNodeContainer.getVirtualNode();
            this.checkVirtualNode(virtualNode);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i]);
            }
        }
    }

    private void checkVirtualNode(VirtualNode virtualNode) throws ADLException {
        String name = virtualNode.getName();
        String host = virtualNode.getHost();
        String number = virtualNode.getNumber();
        if (host == null && number != null) {
            throw new ADLException("virtual-node number can't be defined if virtual-node host isn't defined", (Node)virtualNode);
        }
        if (host != null) {
            ArrayList<String> allocatorNodes = new ArrayList<String>(Arrays.asList(this.allocator.getAllocatedComponentName()));
            allocatorNodes.addAll(new ArrayList<String>(Arrays.asList(this.allocator.getFreeComponentName())));
            if (number != null) {
                if (!allocatorNodes.contains(host + "_" + number)) {
                    throw new ADLException("The JadeNode " + host + "_" + number + " doesnt exist.", (Node)virtualNode);
                }
                if (this.nodes.containsKey(name)) {
                    String value = this.nodes.get(name);
                    String jadenodename = host + "_" + number;
                    if (!jadenodename.startsWith(value)) {
                        throw new ADLException("There is a conflict in virtual-node " + name + ". 2 different JadeNode specified : " + value + " <> " + host + "_" + number, (Node)virtualNode);
                    }
                } else if (this.nodes.containsValue(host + "_" + number)) {
                    Set<String> keys = this.nodes.keySet();
                    for (String key : keys) {
                        if (this.nodes.get(key).equals(host + "_" + number)) continue;
                        this.nodes.remove(key);
                    }
                    if (this.nodes.size() != 0) {
                        throw new ADLException("There is a conflict : The JadeNode " + host + "_" + number + " is specified for 2 <> virtual-nodes : " + this.nodes.keySet().iterator().next() + " & " + name, (Node)virtualNode);
                    }
                } else {
                    this.nodes.put(name, host + "_" + number);
                }
            } else {
                Iterator it = allocatorNodes.iterator();
                boolean found = false;
                while (it.hasNext() && !found) {
                    found = ((String)it.next()).startsWith(host);
                }
                if (!found) {
                    throw new ADLException("The JadeNode " + host + "_" + number + " doesnt exist.", (Node)virtualNode);
                }
                if (this.nodes.containsKey(name)) {
                    String value = this.nodes.get(name);
                    if (!value.startsWith(host)) {
                        throw new ADLException("There is a conflict in virtual-node " + name + ". 2 different host values : " + value + " <> " + host, (Node)virtualNode);
                    }
                } else {
                    this.nodes.put(name, host);
                }
            }
        }
    }

    private void checkVirtualNodeNumber() throws ADLException {
        int freeNodeNumber = this.allocator.getFreeComponentName().length;
        int allocatedNodeNumber = this.allocator.getAllocatedComponent().length;
        if (this.nodes.size() > freeNodeNumber + allocatedNodeNumber) {
            throw new ADLException("Not enough nodes available", null);
        }
        this.nodes.clear();
    }

    public String[] listFc() {
        ArrayList<String> bindings = new ArrayList<String>(Arrays.asList(super.listFc()));
        bindings.add("allocator");
        return bindings.toArray(new String[bindings.size()]);
    }

    public Object lookupFc(String itfName) {
        if (itfName.equals("allocator")) {
            return this.allocator;
        }
        return super.lookupFc(itfName);
    }

    public void bindFc(String itfName, Object itfValue) {
        if (itfName.equals("allocator")) {
            this.allocator = (Allocator)itfValue;
        }
        super.bindFc(itfName, itfValue);
    }

    public void unbindFc(String itfName) {
        if (itfName.equals("allocator")) {
            this.allocator = null;
        }
        super.unbindFc(itfName);
    }
}

