/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.installer.osgi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.deployment.local.api.LocallyInstalledPackage;
import org.objectweb.fractal.deployment.local.api.OSGiInstaller;
import org.objectweb.fractal.deployment.local.api.PackageDescription;
import org.objectweb.jasmine.jade.service.installer.LocallyInstalledPackageImpl;
import org.objectweb.jasmine.jade.util.JadeException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;
import org.ow2.jasmine.jade.bundlerepository.ResolverImpl;
import org.ow2.jasmine.jade.fractal.api.control.OSGiContextController;
import org.ow2.jasmine.jade.fractal.julia.loader.ClassLoaderWrapper;
import org.ungoverned.osgi.service.shell.ShellService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiInstallerImpl
implements OSGiInstaller,
OSGiContextController,
LifeCycleController {
    private boolean started = false;
    private ShellService shell = null;
    private ConfigurationAdmin cm = null;
    private BundleContext bc;
    private List<LocallyInstalledPackage> installedPkgs = new ArrayList<LocallyInstalledPackage>();
    private RepositoryAdmin repoService = null;

    public String getFcState() {
        if (this.started) {
            return "STARTED";
        }
        return "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("[OSGI] already started");
        }
        this.getShellService();
        this.getConfigAdmin();
        this.started = true;
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (this.started) {
            this.started = false;
        }
    }

    public LocallyInstalledPackage install(PackageDescription packageDescription) {
        return this.install(packageDescription, false, true);
    }

    public LocallyInstalledPackage installAndMark(PackageDescription packageDescription) {
        return this.install(packageDescription, true, true);
    }

    public void uninstall(LocallyInstalledPackage cmpPkg) throws JadeException {
        cmpPkg.unInstall();
        this.installedPkgs.remove(cmpPkg);
    }

    public LocallyInstalledPackage[] getInstalledPackages() {
        return this.installedPkgs.toArray(new LocallyInstalledPackage[0]);
    }

    public LocallyInstalledPackage install(PackageDescription packageDescription, boolean isStart) {
        return this.install(packageDescription, false, isStart);
    }

    public LocallyInstalledPackage installAndMark(PackageDescription packageDescription, boolean isStart) {
        return this.install(packageDescription, true, isStart);
    }

    public void addBundleId(Component component, long bundleId) {
    }

    public BundleContext getBundleContext() {
        return this.bc;
    }

    public long getBundleId(Component component) {
        return 0L;
    }

    public void setBundleContext(BundleContext context) {
        this.bc = context;
        ServiceReference obrServiceRef = this.bc.getServiceReference(RepositoryAdmin.class.getName());
        this.repoService = (RepositoryAdmin)this.bc.getService(obrServiceRef);
    }

    private LocallyInstalledPackage install(PackageDescription packageDescription, boolean mark, boolean isStart) {
        LocallyInstalledPackage result2 = null;
        for (LocallyInstalledPackage result2 : this.installedPkgs) {
            if (!packageDescription.equals(result2.getPackageDescription())) continue;
            return result2;
        }
        String resourceName = packageDescription.getPackageID();
        Object version = ((Map)packageDescription.getPackageProperties()).get("version");
        String filterExpr = null;
        filterExpr = version != null ? "(presentationname=" + resourceName + " & version=" + version.toString() + ")" : "(presentationname=" + resourceName + ")";
        Resolver resolver = this.repoService.resolver();
        Resource[] rsrcs = this.repoService.discoverResources(filterExpr);
        if (rsrcs == null) {
            rsrcs = this.repoService.discoverResources("(presentationname=" + resourceName + ")");
        }
        Resource resource = this.selectNewestVersion(rsrcs);
        List dependencyBundles = null;
        Bundle bnd = null;
        try {
            resolver.add(resource);
            resolver.resolve();
            Resource[] resources = resolver.getRequiredResources();
            List dependencyCandidates = null;
            if (resolver instanceof ResolverImpl) {
                dependencyCandidates = ((ResolverImpl)resolver).deployAndSaveDependencies(isStart);
            } else {
                resolver.deploy(isStart);
            }
            if (dependencyCandidates != null && dependencyCandidates.size() > 0) {
                bnd = this.getBundleFromList(dependencyCandidates, resourceName);
                dependencyCandidates.remove(bnd);
                dependencyBundles = dependencyCandidates;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String resourceSymbolicName = resource.getSymbolicName();
        Configuration config = null;
        try {
            config = this.cm.getConfiguration(resourceSymbolicName, null);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        Map pkgProps = (Map)packageDescription.getPackageProperties();
        Dictionary props = config.getProperties();
        if (props == null) {
            props = new Properties();
        }
        if (pkgProps != null && pkgProps.keySet().size() > 0) {
            Iterator it = pkgProps.keySet().iterator();
            while (it.hasNext()) {
                String key = ((String)it.next()).toString();
                String propValue = null;
                try {
                    propValue = (String)pkgProps.get(key);
                    props.put(key, propValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            config.update(props);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (bnd != null) {
            ArrayList<LocallyInstalledPackage> dependencies = new ArrayList<LocallyInstalledPackage>();
            for (Bundle b : dependencyBundles) {
                boolean dependencyAlreadyCreated = false;
                for (LocallyInstalledPackage dependencyCandidate : this.installedPkgs) {
                    if (!b.equals(((LocallyInstalledPackageImpl)dependencyCandidate).getBundle())) continue;
                    dependencies.add(dependencyCandidate);
                    dependencyCandidate.increaseReferenceCounter();
                    dependencyAlreadyCreated = true;
                }
                if (dependencyAlreadyCreated) continue;
                boolean isJadenodeOrJadeboot = false;
                String bundleName = (String)b.getHeaders().get("Bundle-Name");
                isJadenodeOrJadeboot = "jadenode".equals(bundleName) || "jadeboot".equals(bundleName);
                LocallyInstalledPackageImpl dep = null;
                dep = isJadenodeOrJadeboot ? new LocallyInstalledPackageImpl(b, null, null, true) : new LocallyInstalledPackageImpl(b, null, null, false);
                this.installedPkgs.add(dep);
                dependencies.add(dep);
            }
            result2 = new LocallyInstalledPackageImpl(bnd, dependencies, packageDescription);
        } else {
            result2 = new LocallyInstalledPackageImpl(new ClassLoaderWrapper(this.getClass().getClassLoader()), null, packageDescription);
        }
        this.installedPkgs.add(result2);
        return result2;
    }

    private void getShellService() {
        try {
            ServiceReference[] shellRef = this.bc.getServiceReferences(ShellService.class.getName(), null);
            if (shellRef == null) {
                System.out.println("No shell service is available.");
            }
            this.shell = (ShellService)this.bc.getService(shellRef[0]);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void getConfigAdmin() {
        try {
            ServiceReference[] cmRef = this.bc.getServiceReferences(ConfigurationAdmin.class.getName(), null);
            if (cmRef == null) {
                System.out.println("No ConfigAdmin service available.");
            }
            this.cm = (ConfigurationAdmin)this.bc.getService(cmRef[0]);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    private Resource selectNewestVersion(Resource[] resources) {
        int idx = -1;
        Version v = null;
        for (int i = 0; resources != null && i < resources.length; ++i) {
            if (i == 0) {
                idx = 0;
                v = resources[i].getVersion();
                continue;
            }
            Version vtmp = resources[i].getVersion();
            if (vtmp.compareTo((Object)v) <= 0) continue;
            idx = i;
            v = vtmp;
        }
        return idx < 0 ? null : resources[idx];
    }

    private Bundle getBundleFromList(List<Bundle> list, String bundleName) {
        for (Bundle b : list) {
            if (!bundleName.equals(b.getHeaders().get("Bundle-Name"))) continue;
            return b;
        }
        return null;
    }
}

