/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.nodediscovery.analyser;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.jasmine.jade.service.jms.JMSController;
import org.objectweb.jasmine.jade.service.nodediscovery.NodeDiscovery;
import org.objectweb.jasmine.jade.service.nodediscovery.analyser.NodeDiscoveryAnalyser;
import org.objectweb.jasmine.jade.service.nodediscovery.analyser.NodeState;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;

public class NodeDiscoveryAnalyserImpl
implements NodeDiscoveryAnalyser,
NodeDiscovery,
LifeCycleController,
BindingController,
Runnable {
    private boolean started = false;
    private Map nodeList = null;
    private Thread thread;
    private static final int ANALYSE_TIMEOUT = 4;
    private final String[] bindingList = new String[]{"jms", "registry"};
    private JMSController jms = null;
    private NamingService registry = null;
    private javax.jms.Topic addedNodeTopic = null;
    private javax.jms.Topic failedNodeTopic = null;
    private TopicConnection connexion = null;
    private TopicSession session = null;
    private TopicPublisher addedNodePublisher = null;
    private TopicPublisher failedNodePublisher = null;

    public NodeDiscoveryAnalyserImpl() {
        this.nodeList = new HashMap();
    }

    public String getFcState() {
        if (this.started) {
            return "STARTED";
        }
        return "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("Component NodeDiscoverynalyser already started");
        }
        this.thread = new Thread((Runnable)this, "NodeDiscoveryAnalyser");
        this.thread.start();
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (this.started) {
            this.thread.interrupt();
            this.started = false;
        }
    }

    public String[] listFc() {
        return this.bindingList;
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("jms")) {
            return this.jms;
        }
        if (itfName.equals("registry")) {
            return this.registry;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("Component Started");
        }
        if (itfName.equals("jms")) {
            this.jms = (JMSController)itfValue;
        } else if (itfName.equals("registry")) {
            this.registry = (NamingService)itfValue;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("Component Started");
        }
        if (itfName.equals("jms")) {
            this.jms = null;
        } else if (itfName.equals("registry")) {
            this.registry = null;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public void analyse(String nodeName) {
        if (this.started) {
            if (this.nodeList.containsKey(nodeName)) {
                ((NodeState)this.nodeList.get((Object)nodeName)).lastHeartBeat = System.currentTimeMillis();
            } else {
                this.nodeList.put(nodeName, new NodeState());
                try {
                    TextMessage msg = this.session.createTextMessage();
                    msg.setText(nodeName);
                    msg.setJMSExpiration(0L);
                    this.addedNodePublisher.publish((Message)msg);
                    this.session.commit();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                if (this.registry.lookup(nodeName) == null) {
                    this.registry.bind(nodeName, null);
                }
            }
        }
    }

    public Set getNodeList() {
        return this.nodeList.keySet();
    }

    public void run() {
        try {
            this.addedNodeTopic = this.jms.createTopic("AddedNodeTopic");
            this.failedNodeTopic = this.jms.createTopic("FailedNodeTopic");
            this.connexion = (TopicConnection)this.jms.getTopicConnection();
            this.session = this.connexion.createTopicSession(true, 1);
            this.addedNodePublisher = this.session.createPublisher(this.addedNodeTopic);
            this.failedNodePublisher = this.session.createPublisher(this.failedNodeTopic);
            Topic ant = (Topic)this.addedNodeTopic;
            while (ant.getSubscriptions() == 0) {
            }
        }
        catch (ConnectException e) {
            e.printStackTrace();
        }
        catch (AdminException e) {
            e.printStackTrace();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        this.started = true;
        ArrayList<String> nodeToRemove = new ArrayList<String>();
        while (this.started && !this.thread.isInterrupted()) {
            long currentTime = System.currentTimeMillis();
            Iterator it = this.nodeList.keySet().iterator();
            String nodeName = null;
            while (it.hasNext()) {
                nodeName = (String)it.next();
                if (nodeName.equals("jadeboot")) continue;
                NodeState nodeState = (NodeState)this.nodeList.get(nodeName);
                if (nodeState.nodeState != 0 || currentTime - nodeState.lastHeartBeat <= 4000L) continue;
                nodeToRemove.add(nodeName);
                try {
                    TextMessage msg = this.session.createTextMessage();
                    msg.setText(nodeName);
                    this.failedNodePublisher.publish((Message)msg);
                    this.session.commit();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            for (int i = 0; i < nodeToRemove.size(); ++i) {
                this.nodeList.remove(nodeToRemove.get(i));
            }
            nodeToRemove.clear();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {}
        }
    }
}

