/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.nodediscovery.listener;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.StringTokenizer;
import org.objectweb.jasmine.jade.service.nodediscovery.listener.AbstractNodeDiscoveryListener;

public class UDPNodeDiscoveryListener
extends AbstractNodeDiscoveryListener {
    private DatagramSocket socket;
    private byte[] buffer = new byte[128];
    private DatagramPacket packet;

    public UDPNodeDiscoveryListener() {
        try {
            this.socket = new DatagramSocket(new Integer(this.port));
            this.packet = new DatagramPacket(this.buffer, this.buffer.length);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        System.out.println("[NodeDiscovery service] listen on port " + this.port);
    }

    public void listenHeartBeat() {
        try {
            this.socket.receive(this.packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        while (this.started && !this.thread.isInterrupted()) {
            this.listenHeartBeat();
            String message = new String(this.packet.getData(), 0, this.packet.getLength());
            StringTokenizer st = new StringTokenizer(message, ":");
            if (!st.hasMoreTokens()) continue;
            String header = st.nextToken();
            if (!st.hasMoreTokens() || !header.equals("JADENODE")) continue;
            this.analyser.analyse(st.nextToken());
        }
    }
}

