/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.registry.fractalrmi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.rmi.registry.Registry;
import org.objectweb.jasmine.jade.osgi.JadeProperties;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.jasmine.jade.util.Logger;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;

public class RegistryImpl
implements NamingService,
GenericAttributeController {
    private NamingService ns = null;
    static final String[] attList = new String[]{"port"};
    private String host = null;
    private int port = 0;

    public RegistryImpl() throws JadeException {
        try {
            this.host = JadeProperties.getInstance().getJadeRegistryHost();
        }
        catch (Exception e) {
            throw new JadeException("cannot set registry host", e);
        }
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        try {
            if (name.equals("host")) {
                return InetAddress.getLocalHost().getHostName();
            }
            if (name.equals("port")) {
                return String.valueOf(this.port);
            }
            throw new NoSuchAttributeException(name);
        }
        catch (UnknownHostException e) {
            throw new NoSuchAttributeException("unknown host");
        }
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (!name.equals("port")) {
            throw new NoSuchAttributeException(name);
        }
        this.port = new Integer(value);
        if (this.ns == null) {
            this.createRegistry();
        }
    }

    public String[] listFcAtt() {
        return attList;
    }

    public boolean bind(String name, Component comp) {
        if (this.ns == null) {
            this.createRegistry();
        }
        return this.ns.bind(name, comp);
    }

    public String[] list() {
        if (this.ns == null) {
            this.createRegistry();
        }
        return this.ns.list();
    }

    public Component lookup(String name) {
        if (this.ns == null) {
            this.createRegistry();
        }
        return this.ns.lookup(name);
    }

    public Component rebind(String name, Component comp) {
        if (this.ns == null) {
            this.createRegistry();
        }
        return this.ns.rebind(name, comp);
    }

    public Component unbind(String name) {
        if (this.ns == null) {
            this.createRegistry();
        }
        return this.ns.unbind(name);
    }

    private void createRegistry() {
        try {
            HashMap<String, ClassLoader> hints = new HashMap<String, ClassLoader>();
            ClassLoader cl = this.getClass().getClassLoader();
            hints.put("registry-classloader", cl);
            hints.put("component-classloader", cl);
            this.ns = Registry.getRegistry((String)this.host, (int)this.port, hints);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.ns.list();
        }
        catch (Exception e) {
            try {
                Registry.createRegistry((int)this.port, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (Exception e1) {
                Logger.println(true, "cannot create registry on " + this.host + ":" + this.port);
                e1.printStackTrace();
                System.exit(0);
            }
        }
    }
}

