/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.registry.jndi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.jasmine.jade.util.JadeException;
import org.ow2.jasmine.jade.fractal.api.control.GenericAttributeController;
import org.ow2.jasmine.jade.fractal.api.control.NoSuchAttributeException;

public class JndiImpl
implements Context,
GenericAttributeController {
    private boolean registryLaunched = false;
    private Context context = null;
    private String host = null;
    private String[] attList = new String[]{"port", "protocol", "initialContextFactory"};
    private String port = "1239";
    private String protocol = "scn";
    private String initialContextFactory = "fr.dyade.aaa.jndi2.client.NamingContextFactory";

    private void connectRegistry() throws JadeException {
        if (this.initialContextFactory.equals("com.sun.jndi.rmi.registry.RegistryContextFactory") && !this.registryLaunched) {
            try {
                LocateRegistry.createRegistry(1099);
                this.registryLaunched = true;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        try {
            this.host = InetAddress.getLocalHost().getHostName();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.initialContextFactory);
            env.put("java.naming.provider.url", this.protocol + "://" + this.host + ":" + this.port);
            ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.context = new InitialContext(env);
            Thread.currentThread().setContextClassLoader(currentCl);
            System.out.println("[JNDI] connected to " + this.initialContextFactory + " on " + this.host + ":" + this.port);
        }
        catch (UnknownHostException e) {
            throw new JadeException("[JNDI] Cannot set registry host", e);
        }
        catch (NamingException e) {
            throw new JadeException("[JNDI] Cannot create InitialContext", e);
        }
    }

    public String getAttribute(String name) throws NoSuchAttributeException {
        if (name.equals("port")) {
            return this.port;
        }
        if (name.equals("protocol")) {
            return this.protocol;
        }
        if (name.equals("initialContextFactory")) {
            return this.initialContextFactory;
        }
        throw new NoSuchAttributeException(name);
    }

    public void setAttribute(String name, String value) throws NoSuchAttributeException {
        if (name.equals("port")) {
            this.port = value;
        } else if (name.equals("protocol")) {
            this.protocol = value;
        } else if (name.equals("initialContextFactory")) {
            this.initialContextFactory = value;
        } else {
            throw new NoSuchAttributeException(name);
        }
    }

    public String[] listFcAtt() {
        return this.attList;
    }

    public synchronized Object lookup(Name name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.lookup(name);
    }

    public synchronized Object lookup(String name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.lookup(name);
    }

    public synchronized void bind(Name name, Object obj) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.bind(name, obj);
    }

    public synchronized void bind(String name, Object obj) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.bind(name, obj);
    }

    public synchronized void rebind(Name name, Object obj) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.rebind(name, obj);
    }

    public synchronized void rebind(String name, Object obj) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.rebind(name, obj);
    }

    public synchronized void unbind(Name name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.unbind(name);
    }

    public synchronized void unbind(String name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.unbind(name);
    }

    public synchronized void rename(Name oldName, Name newName) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.rename(oldName, newName);
    }

    public synchronized void rename(String oldName, String newName) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.rename(oldName, newName);
    }

    public synchronized NamingEnumeration list(Name name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.list(name);
    }

    public synchronized NamingEnumeration list(String name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.list(name);
    }

    public synchronized NamingEnumeration listBindings(Name name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.listBindings(name);
    }

    public synchronized NamingEnumeration listBindings(String name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.listBindings(name);
    }

    public synchronized void destroySubcontext(Name name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.destroySubcontext(name);
    }

    public synchronized void destroySubcontext(String name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.destroySubcontext(name);
    }

    public synchronized Context createSubcontext(Name name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.createSubcontext(name);
    }

    public synchronized Context createSubcontext(String name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.createSubcontext(name);
    }

    public synchronized Object lookupLink(Name name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.lookupLink(name);
    }

    public synchronized Object lookupLink(String name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.lookupLink(name);
    }

    public synchronized NameParser getNameParser(Name name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.getNameParser(name);
    }

    public synchronized NameParser getNameParser(String name) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.getNameParser(name);
    }

    public synchronized Name composeName(Name name, Name prefix) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.composeName(name, prefix);
    }

    public synchronized String composeName(String name, String prefix) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.composeName(name, prefix);
    }

    public synchronized Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.addToEnvironment(propName, propVal);
    }

    public synchronized Object removeFromEnvironment(String propName) throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.removeFromEnvironment(propName);
    }

    public synchronized Hashtable getEnvironment() throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.getEnvironment();
    }

    public synchronized void close() throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        this.context.close();
    }

    public synchronized String getNameInNamespace() throws NamingException {
        if (this.context == null) {
            try {
                this.connectRegistry();
            }
            catch (JadeException e) {
                e.printStackTrace();
            }
        }
        return this.context.getNameInNamespace();
    }
}

