/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.jasmine.jade.util.ParseConfigFile;

public class ParseConfigFileImpl
implements ParseConfigFile {
    String filename;
    String[] buffer;
    boolean keepComments;
    int index = 0;

    public ParseConfigFileImpl(String f) {
        this.filename = f;
    }

    public void open(int buffSize, boolean keepCmnts) throws JadeException {
        String line;
        RandomAccessFile in;
        this.keepComments = keepCmnts;
        this.buffer = new String[buffSize];
        try {
            in = new RandomAccessFile(this.filename, "r");
            line = in.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JadeException("ParseConfigFileImpl: pb opening the file : " + this.filename, e);
        }
        while (line != null) {
            try {
                if (!this.keepComments && line.startsWith("#")) {
                    line = in.readLine();
                    continue;
                }
                if (this.index == this.buffer.length) {
                    throw new JadeException("ParseConfigFileImpl: Buffer overflow");
                }
                this.buffer[this.index++] = line;
                line = in.readLine();
            }
            catch (IOException e) {
                throw new JadeException("ParseConfigFileImpl: pb reading a file", e);
            }
        }
        try {
            in.close();
        }
        catch (IOException e) {
            throw new JadeException("ParseConfigFileImpl: pb closing a file", e);
        }
    }

    public void close() throws JadeException {
        RandomAccessFile output;
        File fname = new File(this.filename);
        fname.delete();
        try {
            output = new RandomAccessFile(this.filename, "rw");
        }
        catch (FileNotFoundException e) {
            throw new JadeException("ParseConfigFileImpl: pb creating a file", e);
        }
        for (int i = 0; i < this.index; ++i) {
            try {
                output.writeBytes(this.buffer[i] + "\n");
                continue;
            }
            catch (IOException e) {
                throw new JadeException("ParseConfigFileImpl: pb writing a file", e);
            }
        }
        try {
            output.close();
        }
        catch (IOException e) {
            throw new JadeException("ParseConfigFileImpl: pb closing a file", e);
        }
    }

    public String setProperty(String prop, String value) {
        for (int i = 0; i < this.index; ++i) {
            String tok;
            if (this.keepComments && this.buffer[i].startsWith("#")) continue;
            StringTokenizer st = new StringTokenizer(this.buffer[i], " \t\n\r", false);
            try {
                tok = st.nextToken();
            }
            catch (Exception ex) {
                continue;
            }
            if (!tok.equals(prop)) continue;
            String oldvalue = st.nextToken();
            this.buffer[i] = prop + " " + value;
            return oldvalue;
        }
        return null;
    }

    public String getProperty(String prop) {
        for (int i = 0; i < this.index; ++i) {
            if (this.keepComments && this.buffer[i].startsWith("#")) continue;
            StringTokenizer st = new StringTokenizer(this.buffer[i], " \t\n\r", false);
            try {
                String tok = st.nextToken();
                if (!tok.equals(prop)) continue;
                tok = st.nextToken();
                return tok;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }

    public void substitute(String from, String to) {
        for (int i = 0; i < this.index; ++i) {
            if (this.keepComments && this.buffer[i].startsWith("#")) continue;
            this.buffer[i] = this.buffer[i].replaceAll(from, to);
        }
    }

    public void append(String line) throws JadeException {
        if (this.index == this.buffer.length) {
            throw new JadeException("ParseConfigFileImpl: Buffer overflow");
        }
        this.buffer[this.index++] = line;
    }
}

