/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.allocator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.NamingException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.service.allocator.Allocator;
import org.objectweb.jasmine.jade.service.allocator.NoNodeAvailableException;
import org.objectweb.jasmine.jade.service.allocator.NodeNotFoundException;
import org.objectweb.jasmine.jade.service.jms.JMSController;
import org.objectweb.jasmine.jade.util.JadeException;
import org.objectweb.jasmine.jade.util.Logger;

public class AllocatorImpl
implements LifeCycleController,
BindingController,
Allocator {
    private boolean started = false;
    private final String[] bindingList = new String[]{"jms_jndi", "registry", "jms"};
    private Component myself;
    private Context jmsJndi;
    private NamingService registry;
    private JMSController jms;
    private Set<String> freeNodes = new TreeSet<String>();
    private Set failedNodes = new HashSet();
    private Map<String, Component> allocatedNodes = new HashMap<String, Component>();
    private TopicConnection topicConnection = null;
    private TopicSession topicSession = null;
    private static final String NEW_NODE_TOPIC_NAME = "AddedNodeTopic";
    private static final String FAILED_NODE_TOPIC_NAME = "FailedNodeTopic";

    public String getFcState() {
        if (this.started) {
            return "STARTED";
        }
        return "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        if (!this.started) {
            this.registry.bind("allocator", this.myself);
            this.started = true;
            try {
                this.subscribeJmsTopic();
            }
            catch (JMSException e) {
                throw new IllegalLifeCycleException("The allocator can't subscribe to Joram topics");
            }
            Logger.println("[Allocator] started");
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (this.started) {
            this.started = false;
        }
    }

    public String[] listFc() {
        return this.bindingList;
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("component")) {
            return this.myself;
        }
        if (itfName.equals("jms_jndi")) {
            return this.jmsJndi;
        }
        if (itfName.equals("registry")) {
            return this.registry;
        }
        if (itfName.equals("jms")) {
            return this.jms;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException(itfName);
        }
        if (itfName.equals("component")) {
            this.myself = (Component)itfValue;
        }
        if (itfName.equals("jms_jndi")) {
            this.jmsJndi = (Context)itfValue;
        } else if (itfName.equals("registry")) {
            this.registry = (NamingService)itfValue;
        } else if (itfName.equals("jms")) {
            this.jms = (JMSController)itfValue;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException(itfName);
        }
        if (itfName.equals("component")) {
            this.myself = null;
        }
        if (itfName.equals("jms_jndi")) {
            this.jmsJndi = null;
        } else if (itfName.equals("registry")) {
            this.registry = null;
        } else if (itfName.equals("jms")) {
            this.jms = null;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public Component alloc() throws NoNodeAvailableException {
        Component res = null;
        if (!this.freeNodes.isEmpty()) {
            String node = this.freeNodes.iterator().next();
            res = this.registry.lookup(node);
            this.freeNodes.remove(node);
            this.allocatedNodes.put(node, res);
        } else if (!this.allocatedNodes.isEmpty()) {
            int random = new Random().nextInt(this.allocatedNodes.size());
            Iterator<String> keys = this.allocatedNodes.keySet().iterator();
            for (int i = 0; i < random - 1; ++i) {
                keys.next();
            }
            res = this.allocatedNodes.get(keys.next());
        } else {
            throw new NoNodeAvailableException("No node available to allocate");
        }
        return res;
    }

    public Component alloc(String host) throws NodeNotFoundException {
        Component res = null;
        String node = null;
        boolean found = false;
        Iterator<String> it = this.freeNodes.iterator();
        while (it.hasNext() && !found) {
            node = it.next();
            found = node.startsWith(host);
        }
        if (found) {
            res = this.registry.lookup(node);
            this.freeNodes.remove(node);
            this.allocatedNodes.put(node, res);
        } else {
            it = this.allocatedNodes.keySet().iterator();
            while (it.hasNext() && !found) {
                node = it.next();
                found = node.startsWith(host);
            }
            if (found) {
                res = this.allocatedNodes.get(node);
            } else {
                throw new NodeNotFoundException("No JadeNode with name begining with \"" + host + "\" found");
            }
        }
        return res;
    }

    public Component alloc(String host, String number) throws NodeNotFoundException {
        String node = host + "_" + number;
        Component res = null;
        if (this.freeNodes.contains(node)) {
            res = this.registry.lookup(node);
            this.freeNodes.remove(node);
            this.allocatedNodes.put(node, res);
        } else if (this.allocatedNodes.containsKey(node)) {
            res = this.allocatedNodes.get(node);
        } else {
            throw new NodeNotFoundException("The JadeNode " + node + " doesn't exist.");
        }
        return res;
    }

    public void free(Component c) throws JadeException {
        try {
            String node = ((NameController)c.getFcInterface("name-controller")).getFcName();
            if (!this.allocatedNodes.containsKey(node)) {
                throw new JadeException("[Allocator] Unable to free the node \"" + node + "\" : node not found");
            }
            this.allocatedNodes.remove(node);
            this.freeNodes.add(node);
        }
        catch (NoSuchInterfaceException e) {
            throw new JadeException("[Allocator] Unable to free node : " + e.getLocalizedMessage());
        }
    }

    public Component[] getAllocatedComponent() {
        return this.allocatedNodes.values().toArray(new Component[0]);
    }

    public Component[] getFreeComponent() {
        return null;
    }

    public boolean isAllocated(Component c) throws NodeNotFoundException {
        try {
            String node = Fractal.getNameController((Component)c).getFcName();
            if (this.allocatedNodes.containsKey(node)) {
                return true;
            }
            if (this.freeNodes.contains(node)) {
                return false;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        throw new NodeNotFoundException();
    }

    public boolean isAllocated(String name) throws NodeNotFoundException {
        if (this.allocatedNodes.containsKey(name)) {
            return true;
        }
        if (this.freeNodes.contains(name)) {
            return false;
        }
        throw new NodeNotFoundException();
    }

    public String[] getAllocatedComponentName() {
        return this.allocatedNodes.keySet().toArray(new String[0]);
    }

    public String[] getFreeComponentName() {
        return this.freeNodes.toArray(new String[0]);
    }

    private void subscribeJmsTopic() throws JMSException {
        Topic newNodeTopic = null;
        Topic failedNodeTopic = null;
        boolean lookup = false;
        while (!lookup) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                newNodeTopic = (Topic)this.jmsJndi.lookup(NEW_NODE_TOPIC_NAME);
                failedNodeTopic = (Topic)this.jmsJndi.lookup(FAILED_NODE_TOPIC_NAME);
                Thread.currentThread().setContextClassLoader(cl);
                lookup = true;
            }
            catch (NamingException ignored) {}
        }
        this.topicConnection = (TopicConnection)this.jms.getTopicConnection();
        this.topicSession = this.topicConnection.createTopicSession(true, 1);
        TopicSubscriber newNodeSubscriber = this.topicSession.createSubscriber(newNodeTopic);
        TopicSubscriber failedNodeSubscriber = this.topicSession.createSubscriber(failedNodeTopic);
        newNodeSubscriber.setMessageListener((MessageListener)new NewNodeMsgListener());
        failedNodeSubscriber.setMessageListener((MessageListener)new FailedNodeMsgListener());
        this.topicConnection.start();
    }

    private void unsubscribeJmstopic() {
        try {
            this.topicSession.unsubscribe(NEW_NODE_TOPIC_NAME);
            this.topicSession.unsubscribe(FAILED_NODE_TOPIC_NAME);
            this.topicConnection.close();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    class FailedNodeMsgListener
    implements MessageListener {
        FailedNodeMsgListener() {
        }

        public void onMessage(Message msg) {
            if (msg instanceof TextMessage) {
                try {
                    String failedNode = ((TextMessage)msg).getText();
                    System.out.println("[Allocator] receive failedNode jmsMessage : " + failedNode);
                    AllocatorImpl.this.failedNodes.add(failedNode);
                    if (AllocatorImpl.this.freeNodes.contains(failedNode)) {
                        AllocatorImpl.this.freeNodes.remove(failedNode);
                    }
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class NewNodeMsgListener
    implements MessageListener {
        NewNodeMsgListener() {
        }

        public void onMessage(Message msg) {
            if (msg instanceof TextMessage) {
                try {
                    String newNode = ((TextMessage)msg).getText();
                    System.out.println("[Allocator] receive newNode jmsMessage : " + newNode);
                    AllocatorImpl.this.freeNodes.add(newNode);
                    if (AllocatorImpl.this.failedNodes.contains(newNode)) {
                        AllocatorImpl.this.failedNodes.remove(newNode);
                    }
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

