/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.deployer.adl.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.deployment.scheduling.component.api.FactoryProviderTask;
import org.objectweb.deployment.scheduling.component.lib.AbstractInstanceProviderTask;
import org.objectweb.deployment.scheduling.core.api.Task;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.TaskMap;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.adl.implementations.ControllerContainer;
import org.objectweb.fractal.adl.implementations.Implementation;
import org.objectweb.fractal.adl.implementations.ImplementationContainer;
import org.objectweb.fractal.adl.implementations.TemplateControllerContainer;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jasmine.jade.service.deployer.adl.implementations.Controller;
import org.objectweb.jasmine.jade.service.deployer.adl.implementations.ImplementationBuilder;
import org.objectweb.jasmine.jade.service.deployer.adl.nodes.VirtualNode;
import org.objectweb.jasmine.jade.service.deployer.adl.nodes.VirtualNodeContainer;
import org.objectweb.jasmine.jade.service.deployer.adl.packages.Package;
import org.objectweb.jasmine.jade.service.deployer.adl.packages.PackageDescriptionImpl;
import org.objectweb.jasmine.jade.service.deployer.adl.packages.Packages;
import org.objectweb.jasmine.jade.service.deployer.adl.packages.PackagesContainer;
import org.objectweb.jasmine.jade.service.deployer.adl.property.Property;
import org.objectweb.jasmine.jade.service.deployer.adl.property.PropertyContainer;

public class ImplementationCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public ImplementationBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (ImplementationBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        Packages packages;
        TemplateControllerContainer tcc;
        ControllerContainer cc;
        Controller ctrl;
        ImplementationContainer ic;
        Implementation i;
        VirtualNode virtualNode;
        Task virtualNodeCleanTask = tasks.getTask("cleanNodes", (Object)"beurk");
        String virtualNodeName = null;
        Task virtualNodeCreationTask = null;
        if (container instanceof VirtualNodeContainer && (virtualNode = ((VirtualNodeContainer)container).getVirtualNode()) != null) {
            virtualNodeName = virtualNode.getName();
            try {
                virtualNodeCreationTask = tasks.getTask("allocNode", (Object)virtualNodeName);
            }
            catch (NoSuchElementException ignored) {
                // empty catch block
            }
        }
        boolean template = context != null && "true".equals(context.get("template"));
        String implementation = null;
        if (container instanceof ImplementationContainer && (i = (ic = (ImplementationContainer)container).getImplementation()) != null) {
            implementation = i.getClassName();
        }
        Object controller = null;
        if (container instanceof ControllerContainer && (ctrl = (Controller)(cc = (ControllerContainer)container).getController()) != null) {
            String files = ctrl.getFiles();
            if (files != null && files.trim().length() > 0) {
                controller = new HashMap();
                ((Map)controller).put("juliaconfig", files);
                ((Map)controller).put("controller", ctrl.getDescriptor());
            } else {
                controller = ctrl.getDescriptor();
            }
        }
        String templateController = null;
        if (container instanceof TemplateControllerContainer && (tcc = (TemplateControllerContainer)container).getTemplateController() != null) {
            templateController = tcc.getTemplateController().getDescriptor();
            template = true;
        }
        String name = null;
        if (container instanceof Definition) {
            name = ((Definition)container).getName();
        } else if (container instanceof Component) {
            name = ((Component)container).getName();
        }
        String definition = null;
        definition = container instanceof Definition ? name : (String)((Node)container).astGetDecoration("definition");
        Object[] packageDesc = null;
        if (container instanceof PackagesContainer && (packages = ((PackagesContainer)container).getPackages()) != null) {
            Package[] pkgs = packages.getPackages();
            ArrayList<PackageDescriptionImpl> packageDescList = new ArrayList<PackageDescriptionImpl>();
            Package pkg = null;
            for (int i2 = 0; i2 < pkgs.length; ++i2) {
                String version;
                HashMap<String, String> propertiesMap = new HashMap<String, String>();
                pkg = pkgs[i2];
                Property[] properties = ((PropertyContainer)((Object)pkg)).getPropertys();
                if (properties != null && properties.length > 0) {
                    for (int j = 0; j < properties.length; ++j) {
                        propertiesMap.put(properties[j].getName(), properties[j].getValue());
                    }
                }
                if ((version = pkg.getVersion()) != null) {
                    propertiesMap.put("version", version);
                }
                packageDescList.add(new PackageDescriptionImpl(pkg.getName(), propertiesMap));
            }
            packageDesc = packageDescList.toArray();
        }
        boolean attrs = false;
        if (container instanceof AttributesContainer) {
            attrs = ((AttributesContainer)container).getAttributes() != null;
        }
        Component[] comps = container.getComponents();
        try {
            tasks.getTask("create", (Object)container);
        }
        catch (NoSuchElementException e) {
            AbstractInstanceProviderTask createTask;
            if (comps.length > 0 || implementation == null) {
                if (implementation != null) {
                    throw new ADLException("Implementation must be empty", (Node)container);
                }
                if (controller == null) {
                    controller = "composite";
                }
                if (template) {
                    if (templateController == null) {
                        templateController = attrs ? "parametricCompositeTemplate" : "compositeTemplate";
                    }
                    if (virtualNodeCreationTask != null) {
                        createTask = this.newRemoteCreateTask(path, container, name, definition, templateController, new Object[]{controller, null}, packageDesc, virtualNodeCreationTask, context);
                        createTask.addPreviousTask(virtualNodeCreationTask);
                    } else {
                        createTask = this.newCreateTask(path, container, name, definition, templateController, new Object[]{controller, null}, packageDesc, context);
                    }
                } else if (virtualNodeCreationTask != null) {
                    createTask = this.newRemoteCreateTask(path, container, name, definition, controller, null, packageDesc, virtualNodeCreationTask, context);
                    createTask.addPreviousTask(virtualNodeCreationTask);
                } else {
                    createTask = this.newCreateTask(path, container, name, definition, controller, null, packageDesc, context);
                }
            } else {
                if (controller == null) {
                    controller = "primitive";
                }
                if (template) {
                    if (templateController == null) {
                        templateController = attrs ? "parametricPrimitiveTemplate" : "primitiveTemplate";
                    }
                    if (virtualNodeCreationTask != null) {
                        createTask = this.newRemoteCreateTask(path, container, name, definition, templateController, new Object[]{controller, implementation}, packageDesc, virtualNodeCreationTask, context);
                        createTask.addPreviousTask(virtualNodeCreationTask);
                    } else {
                        createTask = this.newCreateTask(path, container, name, definition, templateController, new Object[]{controller, implementation}, packageDesc, context);
                    }
                } else if (virtualNodeCreationTask != null) {
                    createTask = this.newRemoteCreateTask(path, container, name, definition, controller, implementation, packageDesc, virtualNodeCreationTask, context);
                    createTask.addPreviousTask(virtualNodeCreationTask);
                } else {
                    createTask = this.newCreateTask(path, container, name, definition, controller, implementation, packageDesc, context);
                }
            }
            FactoryProviderTask typeTask = (FactoryProviderTask)tasks.getTask("type", (Object)container);
            createTask.setFactoryProviderTask(typeTask);
            virtualNodeCleanTask.addPreviousTask((Task)createTask);
            tasks.addTask("create", (Object)container, (Task)createTask);
        }
    }

    public AbstractInstanceProviderTask newCreateTask(List path, ComponentContainer container, String name, String definition, Object controller, Object implementation, Object[] packageDesc, Map context) {
        return new CreateTask(this.builder, name, definition, controller, implementation, packageDesc);
    }

    public AbstractInstanceProviderTask newRemoteCreateTask(List path, ComponentContainer container, String name, String definition, Object controller, Object implementation, Object[] packageDesc, Task virtualNodeCreationTask, Map context) {
        return new RemoteCreateTask(this.builder, virtualNodeCreationTask, name, definition, controller, implementation, packageDesc);
    }

    static class RemoteCreateTask
    extends CreateTask {
        Task virtualNodeCreationTask;

        public RemoteCreateTask(ImplementationBuilder builder, Task virtualNodeCreationTask, String name, String definition, Object controllerDesc, Object contentDesc, Object[] packageDesc) {
            super(builder, name, definition, controllerDesc, contentDesc, packageDesc);
            this.virtualNodeCreationTask = virtualNodeCreationTask;
        }

        public void execute(Object context) throws Exception {
            if (this.getInstance() != null) {
                return;
            }
            Object type = this.getFactoryProviderTask().getFactory();
            org.objectweb.fractal.api.Component node = (org.objectweb.fractal.api.Component)this.virtualNodeCreationTask.getResult();
            if (node == null) {
                throw new Exception("no node allocated");
            }
            String factoryName = Fractal.getNameController((org.objectweb.fractal.api.Component)node).getFcName();
            ((Map)context).put("factoryName", factoryName);
            Object result = this.builder.createComponent(type, this.name, this.definition, this.controllerDesc, this.contentDesc, this.packageDesc, context);
            this.setInstance(result);
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[CreateTask(" + this.name + "," + this.controllerDesc + "," + this.contentDesc + ")]";
        }
    }

    static class CreateTask
    extends AbstractInstanceProviderTask {
        ImplementationBuilder builder;
        String name;
        String definition;
        Object controllerDesc;
        Object contentDesc;
        Object[] packageDesc;

        public CreateTask(ImplementationBuilder builder, String name, String definition, Object controllerDesc, Object contentDesc, Object[] packageDesc) {
            this.builder = builder;
            this.name = name;
            this.definition = definition;
            this.controllerDesc = controllerDesc;
            this.contentDesc = contentDesc;
            this.packageDesc = packageDesc;
        }

        public void execute(Object context) throws Exception {
            if (this.getInstance() != null) {
                return;
            }
            Object type = this.getFactoryProviderTask().getFactory();
            Object result = this.builder.createComponent(type, this.name, this.definition, this.controllerDesc, this.contentDesc, this.packageDesc, context);
            this.setInstance(result);
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[CreateTask(" + this.name + "," + this.controllerDesc + "," + this.contentDesc + ")]";
        }
    }
}

