/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.deployer.adl.nodes;

import java.util.List;
import java.util.Map;
import org.objectweb.deployment.scheduling.core.api.Task;
import org.objectweb.deployment.scheduling.core.lib.AbstractTask;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.TaskMap;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.jasmine.jade.service.allocator.NoNodeAvailableException;
import org.objectweb.jasmine.jade.service.allocator.NodeNotFoundException;
import org.objectweb.jasmine.jade.service.deployer.adl.nodes.VirtualNode;
import org.objectweb.jasmine.jade.service.deployer.adl.nodes.VirtualNodeBuilder;
import org.objectweb.jasmine.jade.service.deployer.adl.nodes.VirtualNodeContainer;

public class VirtualNodeCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public VirtualNodeBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (VirtualNodeBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        VirtualNode virtualNode;
        if (container instanceof VirtualNodeContainer && (virtualNode = ((VirtualNodeContainer)container).getVirtualNode()) != null) {
            String virtualNodeName = virtualNode.getName();
            String virtualNodeHost = virtualNode.getHost();
            String virtualNodeNumber = virtualNode.getNumber();
            Object virtualNodeCleanTask = null;
            try {
                virtualNodeCleanTask = tasks.getTask("cleanNodes", null);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (virtualNodeCleanTask == null) {
                virtualNodeCleanTask = new VirtualNodeCleanTask(this.builder);
                tasks.addTask("cleanNodes", (Object)"beurk", virtualNodeCleanTask);
            }
            Object virtualNodeCreationTask = null;
            try {
                virtualNodeCreationTask = tasks.getTask("allocNode", (Object)virtualNodeName);
                String host = ((VirtualNodeCreationTask)((Object)virtualNodeCreationTask)).getHost();
                String number = ((VirtualNodeCreationTask)((Object)virtualNodeCreationTask)).getNumber();
                if (virtualNodeHost != null && host == null) {
                    ((VirtualNodeCreationTask)((Object)virtualNodeCreationTask)).setHost(virtualNodeHost);
                }
                if (virtualNodeNumber != null && number == null) {
                    ((VirtualNodeCreationTask)((Object)virtualNodeCreationTask)).setNumber(virtualNodeNumber);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (virtualNodeCreationTask == null) {
                virtualNodeCreationTask = new VirtualNodeCreationTask(this.builder, virtualNodeName, virtualNodeHost, virtualNodeNumber);
                this.scheduleVirtualNodeCreationTask(tasks, (VirtualNodeCreationTask)((Object)virtualNodeCreationTask));
                virtualNodeCleanTask.addPreviousTask(virtualNodeCreationTask);
                tasks.addTask("allocNode", (Object)virtualNodeName, virtualNodeCreationTask);
            }
        }
    }

    private void scheduleVirtualNodeCreationTask(TaskMap tasks, VirtualNodeCreationTask virtualNodeCreationTask) {
        Task nextTask = null;
        if (virtualNodeCreationTask.getNumber() != null) {
            nextTask = this.getFirstVirtualNodeCreationTaskWithHost(tasks);
            if (nextTask == null) {
                nextTask = this.getFirstVirtualNodeCreationTask(tasks);
            }
        } else {
            nextTask = this.getFirstVirtualNodeCreationTask(tasks);
        }
        if (nextTask != null) {
            nextTask.addPreviousTask((Task)virtualNodeCreationTask);
        }
    }

    private Task getFirstVirtualNodeCreationTaskWithHost(TaskMap taskmap) {
        Task[] tasks = taskmap.getTasks();
        int i = 0;
        Task task = null;
        while (i < tasks.length) {
            if (!((task = tasks[i++]) instanceof VirtualNodeCreationTask) || ((VirtualNodeCreationTask)task).getNumber() != null) continue;
            return task;
        }
        return null;
    }

    private Task getFirstVirtualNodeCreationTask(TaskMap taskmap) {
        Task[] tasks = taskmap.getTasks();
        int i = 0;
        Task task = null;
        while (i < tasks.length) {
            if (!((task = tasks[i++]) instanceof VirtualNodeCreationTask)) continue;
            return task;
        }
        return null;
    }

    static class VirtualNodeCleanTask
    extends AbstractTask {
        private VirtualNodeBuilder builder;

        public VirtualNodeCleanTask(VirtualNodeBuilder builder) {
            this.builder = builder;
        }

        public void execute(Object context) throws Exception {
            this.builder.cleanVirtualNodesMap();
        }

        public Object getResult() {
            return null;
        }

        public void setResult(Object result) {
        }
    }

    static class VirtualNodeCreationTask
    extends AbstractTask {
        private VirtualNodeBuilder builder;
        private String virtualNodeName;
        private String virtualNodeHost;
        private String virtualNodeNumber;
        private Component result;

        public VirtualNodeCreationTask(VirtualNodeBuilder builder, String virtualNodeName, String virtualNodeHost, String virtualNodeNumber) {
            this.builder = builder;
            this.virtualNodeName = virtualNodeName;
            this.virtualNodeHost = virtualNodeHost;
            this.virtualNodeNumber = virtualNodeNumber;
        }

        public void execute(Object context) throws NoNodeAvailableException, NodeNotFoundException {
            this.result = this.builder.getVirtualNodeInstance(this.virtualNodeName, this.virtualNodeHost, this.virtualNodeNumber);
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[VirtualNodeCreationTask(" + this.virtualNodeName + ")]";
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = (Component)result;
        }

        public String getHost() {
            return this.virtualNodeHost;
        }

        public void setHost(String virtualNodeHost) {
            this.virtualNodeHost = virtualNodeHost;
        }

        public String getNumber() {
            return this.virtualNodeNumber;
        }

        public void setNumber(String virtualNodeNumber) {
            this.virtualNodeNumber = virtualNodeNumber;
        }
    }
}

