/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.jade.service.jms.joram;

import fr.dyade.aaa.agent.AgentServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.StringTokenizer;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.jasmine.jade.osgi.JadeProperties;
import org.objectweb.jasmine.jade.service.jms.JMSController;
import org.objectweb.jasmine.jade.util.Logger;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.tcp.QueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JoramWrapperImpl
implements JMSController,
LifeCycleController,
BindingController {
    private boolean started = false;
    private final String[] bindingList = new String[]{"registry", "jms_jndi"};
    private NamingService registry = null;
    private Context jmsJndi = null;
    private TopicConnectionFactory topicConnectionFactory = null;
    private QueueConnectionFactory queueConnectionFactory = null;
    private String connectionLogin = "root";
    private String connectionPasswd = "root";
    private int tcpProxyPort = 12080;
    private String serverHost = JadeProperties.getInstance().getDefaultInetAddress().getHostAddress();

    public String getFcState() {
        if (this.started) {
            return "STARTED";
        }
        return "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.getJoramParameterFromA3serverFile();
            this.startJoramServer();
            AdminModule.collocatedConnect((String)this.connectionLogin, (String)this.connectionPasswd);
            this.started = true;
            Logger.println(true, "[Joram server] started");
        }
        catch (Exception e) {
            throw new IllegalLifeCycleException("Error while launching joram server");
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        AdminModule.disconnect();
        this.started = false;
        Logger.println(true, "[Joram server] stopped");
    }

    public String[] listFc() {
        return this.bindingList;
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("registry")) {
            return this.registry;
        }
        if (itfName.equals("jms_jndi")) {
            return this.jmsJndi;
        }
        throw new NoSuchInterfaceException(itfName);
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("Component Started");
        }
        if (itfName.equals("registry")) {
            this.registry = (NamingService)itfValue;
        } else if (itfName.equals("jms_jndi")) {
            this.jmsJndi = (Context)itfValue;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (this.started) {
            throw new IllegalLifeCycleException("Component Started");
        }
        if (itfName.equals("registry")) {
            this.registry = null;
        } else if (itfName.equals("jms_jndi")) {
            this.jmsJndi = null;
        } else {
            throw new NoSuchInterfaceException(itfName);
        }
    }

    public Topic createTopic(String name) throws ConnectException, AdminException, NamingException {
        Topic topic = Topic.create((String)name);
        topic.setFreeReading();
        topic.setFreeWriting();
        this.jmsJndi.bind(name, (Object)topic);
        return topic;
    }

    public Queue createQueue(String name) throws ConnectException, AdminException, NamingException {
        Queue queue = Queue.create((String)name);
        queue.setFreeReading();
        queue.setFreeWriting();
        this.jmsJndi.bind(name, (Object)queue);
        return queue;
    }

    public Connection getTopicConnection() throws JMSException {
        if (this.topicConnectionFactory == null) {
            this.topicConnectionFactory = new TopicTcpConnectionFactory(this.serverHost, this.tcpProxyPort);
            try {
                this.jmsJndi.bind("tcf", (Object)this.topicConnectionFactory);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.topicConnectionFactory.createTopicConnection(this.connectionLogin, this.connectionPasswd);
    }

    public Connection getQueueConnection() throws JMSException {
        if (this.queueConnectionFactory == null) {
            this.queueConnectionFactory = new QueueTcpConnectionFactory(this.serverHost, this.tcpProxyPort);
        }
        return this.queueConnectionFactory.createConnection(this.connectionLogin, this.connectionPasswd);
    }

    private void startJoramServer() {
        try {
            AgentServer.init((short)0, (String)"./s0", null);
            AgentServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopJoramServer() {
        AgentServer.stop();
    }

    private void getJoramParameterFromA3serverFile() throws ParserConfigurationException, SAXException, IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream("a3servers.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(is);
        NodeList nodesService = document.getElementsByTagName("service");
        for (int i = 0; i < nodesService.getLength(); ++i) {
            Element nodeServer = (Element)nodesService.item(i);
            String classValue = nodeServer.getAttribute("class");
            if (classValue.equals("org.objectweb.joram.mom.proxies.ConnectionManager")) {
                String argsValue = nodeServer.getAttribute("args");
                StringTokenizer tokenizer = new StringTokenizer(argsValue, " ");
                this.connectionLogin = tokenizer.nextToken();
                this.connectionPasswd = tokenizer.nextToken();
            }
            if (!classValue.equals("org.objectweb.joram.mom.proxies.tcp.TcpProxyService")) continue;
            this.tcpProxyPort = new Integer(nodeServer.getAttribute("args"));
        }
    }
}

