/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.legacy.jonas4;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipArchive;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class Activator
implements BundleActivator,
ManagedService {
    private static final String PID = "org.ow2.jasmine.jade.wrapper.jonas4";
    private Dictionary properties = null;
    private ServiceRegistration registration = null;
    private BundleContext context = null;
    private Logger logger = Logger.getLogger((class$org$ow2$jasmine$jade$legacy$jonas4$Activator == null ? (class$org$ow2$jasmine$jade$legacy$jonas4$Activator = Activator.class$("org.ow2.jasmine.jade.legacy.jonas4.Activator")) : class$org$ow2$jasmine$jade$legacy$jonas4$Activator).getName());
    private String dirLocal = null;
    private String dirInstall = null;
    private static final String JONAS_DIR = "JONAS_4_8_4" + File.separator;
    private static final String ARCHIVE = "jonas4.8.4-tomcat5.5.17.zip";
    private boolean started = false;
    static /* synthetic */ Class class$org$ow2$jasmine$jade$legacy$jonas4$Activator;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;

    public void start(BundleContext context) throws Exception {
        if (!this.started) {
            this.registration = context.registerService((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = Activator.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (Object)this, this.getDefaults());
            this.context = context;
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.uninstall();
        this.started = false;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties != null) {
            this.properties = properties;
            try {
                if (!this.started) {
                    this.dirLocal = this.getDirLocal();
                    this.dirInstall = this.dirLocal + JONAS_DIR;
                    this.started = this.install();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getDirLocal() {
        String result = (String)this.properties.get("local.dir");
        if (!result.endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    private Dictionary getDefaults() {
        Hashtable<String, String> defaults = new Hashtable<String, String>();
        ((Dictionary)defaults).put("service.pid", PID);
        return defaults;
    }

    private boolean install() {
        this.logger.log(Level.INFO, "The JOnAS directory is now localised on : " + this.dirLocal);
        try {
            File dir = new File(this.dirLocal);
            if (!dir.exists()) {
                dir.mkdirs();
                File archive = new File(this.dirLocal + ARCHIVE);
                if (!archive.exists()) {
                    this.logger.log(Level.INFO, "copying jonas4.8.4-tomcat5.5.17.zip to the local dir...");
                    URL url = this.context.getBundle().getResource(ARCHIVE);
                    BufferedInputStream fis = new BufferedInputStream(url.openConnection().getInputStream());
                    FileOutputStream out = new FileOutputStream(archive);
                    while (fis.available() > 0) {
                        byte[] byts = new byte[fis.available()];
                        fis.read(byts);
                        out.write(byts);
                    }
                    out.flush();
                    fis.close();
                    out.close();
                }
                this.logger.log(Level.INFO, "extracting the 'jonas4.8.4-tomcat5.5.17.zip' in the local dir...");
                ZipArchive zipArchiver = new ZipArchive();
                zipArchiver.setArchive(archive);
                zipArchiver.unpack(dir);
                archive.delete();
                this.logger.log(Level.INFO, "JOnAS is now installed in " + this.dirLocal);
            } else {
                this.logger.log(Level.INFO, "The directory " + this.dirLocal + " already exists.");
            }
            return true;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void uninstall() {
        this.logger.log(Level.INFO, "deleting JOnAS directory...");
        File file = new File(this.dirInstall);
        Activator.deleteDir(file);
        this.logger.log(Level.INFO, "done");
    }

    private static boolean deleteDir(File dir) {
        File candir;
        if (!dir.isDirectory()) {
            return false;
        }
        try {
            candir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(dir.getAbsoluteFile())) {
            return false;
        }
        File[] files = candir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                boolean deleted = file.delete();
                if (deleted || !file.isDirectory()) continue;
                Activator.deleteDir(file);
            }
        }
        return dir.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

