/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.configurator.statik.velocity;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.objectweb.jasmine.configurator.ConfigurationException;
import org.objectweb.jasmine.configurator.statik.velocity.VelocityConfigurator;

public class VelocityConfiguratorImpl
implements VelocityConfigurator {
    private VelocityEngine ve = null;
    private VelocityContext context = null;
    private Template template = null;
    private String templateName = null;
    private String fileName = null;

    public VelocityConfiguratorImpl() {
        this.ve = new VelocityEngine();
        this.context = new VelocityContext();
        this.context.put("this", (Object)this);
    }

    public VelocityConfiguratorImpl(ClassLoader cl) {
        try {
            this.ve = new VelocityEngine();
            this.context = new VelocityContext();
            this.context.put("this", (Object)this);
            this.ve.setProperty("resource.loader", (Object)"class");
            this.ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            if (cl != null) {
                this.ve.setProperty("class.resource.loader.classloader", (Object)cl);
            }
            this.ve.init();
        }
        catch (ResourceNotFoundException rnfe) {
            System.out.println("cannot find template " + this.getTemplateFile());
        }
        catch (ParseErrorException pee) {
            System.out.println("Syntax error in template " + this.getTemplateFile() + ":" + (Object)((Object)pee));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VelocityConfiguratorImpl(VelocityContext vcontext, ClassLoader cl) {
        try {
            this.ve = new VelocityEngine();
            this.context = new VelocityContext((Context)vcontext);
            this.context.put("this", (Object)this);
            this.ve.setProperty("resource.loader", (Object)"class");
            this.ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            if (cl != null) {
                this.ve.setProperty("class.resource.loader.classloader", (Object)cl);
            }
            this.ve.init();
        }
        catch (ResourceNotFoundException rnfe) {
            System.out.println("cannot find template " + this.getTemplateFile());
        }
        catch (ParseErrorException pee) {
            System.out.println("Syntax error in template " + this.getTemplateFile() + ":" + (Object)((Object)pee));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VelocityConfiguratorImpl(VelocityContext vcontext, ClassLoader cl, String templateName, String fileName) {
        try {
            this.ve = new VelocityEngine();
            this.context = new VelocityContext((Context)vcontext);
            this.context.put("this", (Object)this);
            this.ve.setProperty("resource.loader", (Object)"class");
            this.ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            if (cl != null) {
                this.ve.setProperty("class.resource.loader.classloader", (Object)cl);
            }
            this.ve.init();
            this.templateName = templateName;
            this.fileName = fileName;
        }
        catch (ResourceNotFoundException rnfe) {
            System.out.println("cannot find template " + this.getTemplateFile());
        }
        catch (ParseErrorException pee) {
            System.out.println("Syntax error in template " + this.getTemplateFile() + ":" + (Object)((Object)pee));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void configure() throws ConfigurationException {
        try {
            this.write(this.getGeneratedFileName());
        }
        catch (ResourceNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (ParseErrorException e) {
            throw new ConfigurationException(e);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public boolean setProperty(String key, Object value) {
        this.context.put(key, value);
        return true;
    }

    public Object getProperty(String key) {
        return this.context.get(key);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (Object key : this.context.getKeys()) {
            properties.put(key, this.context.get(key.toString()));
        }
        return properties;
    }

    public VelocityContext getContext() {
        return this.context;
    }

    public String getGeneratedFileName() {
        File file;
        String installDir = this.context.get("install-dir").toString();
        if (installDir != null && (file = new File(installDir)).exists() && file.isDirectory()) {
            return installDir + File.separator + this.fileName;
        }
        return this.fileName;
    }

    public String getTemplateFile() {
        return this.templateName;
    }

    private void write(String filename) throws ResourceNotFoundException, ParseErrorException, Exception {
        File file = new File(filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        StringWriter writer = new StringWriter();
        this.template = this.ve.getTemplate(this.getTemplateFile());
        if (this.template != null) {
            this.template.merge((Context)this.context, (Writer)writer);
        }
        String buffer = writer.getBuffer().toString();
        while (buffer.startsWith(" ")) {
            buffer = buffer.replaceFirst(" ", "");
        }
        out.write(buffer);
        out.close();
    }
}

