/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.configurator.statik.velocity.templategenerator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;
import java.util.Properties;
import org.objectweb.jasmine.configurator.statik.velocity.templategenerator.AbstractTemplateGenerator;

public class PropertiesTemplateGenerator
extends AbstractTemplateGenerator {
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";

    public PropertiesTemplateGenerator(String prefix) {
        super(prefix);
    }

    public void generate(File file) throws Exception {
        String line;
        String path = file.getAbsolutePath();
        File templateFile = new File(path.replace(PROPERTIES_FILE_EXTENSION, ".vm"));
        BufferedReader in = new BufferedReader(new FileReader(file));
        BufferedWriter out = new BufferedWriter(new FileWriter(templateFile));
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        StringBuffer buffer = new StringBuffer();
        for (Object key : properties.keySet()) {
            String value = properties.getProperty(key.toString());
            List<String[]> list = this.proceedProperty(key.toString(), value);
            for (String[] s : list) {
                String k = s[0];
                String v = s[1];
                this.templateVars.add(k);
                buffer.append(this.getDefaultPattern(k, v));
                buffer.append("\n");
            }
        }
        out.write(buffer.toString());
        while ((line = in.readLine()) != null) {
            String toWrite = line;
            for (Object key : properties.keySet()) {
                if (!line.contains(key.toString())) continue;
                String value = properties.get(key.toString()).toString();
                if ("".equals(value)) break;
                String prfx = this.format(key.toString());
                if (value.contains("://")) {
                    if (value.substring(value.indexOf("://") + 3, value.length()).contains(":")) {
                        toWrite = this.replaceLast(line, value, "${" + prfx + "-protocol}://${" + prfx + "-host}:${" + prfx + "-port}");
                        break;
                    }
                    toWrite = this.replaceLast(line, value, "${" + prfx + "-protocol}://${" + prfx + "-host}");
                    break;
                }
                toWrite = this.replaceLast(line, value, "${" + prfx + "}");
                break;
            }
            out.write(toWrite);
            out.write("\n");
        }
        out.close();
        in.close();
    }

    private String replaceLast(String string, String oldChar, String newChar) {
        int idx = string.lastIndexOf(oldChar);
        if (idx == -1) {
            return string;
        }
        String firstPart = string.substring(0, idx);
        String secondPart = string.substring(idx, string.length()).replace(oldChar, newChar);
        return firstPart + secondPart;
    }

    public static void main(String[] args) {
        PropertiesTemplateGenerator ptg = new PropertiesTemplateGenerator("carol");
        File jonasProps = new File("/home/legrandj/Desktop/conf/carol.properties");
        try {
            ptg.generate(jonasProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

