/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.configurator.statik.velocity.templategenerator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.objectweb.jasmine.configurator.statik.velocity.templategenerator.AbstractTemplateGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLTemplateGenerator
extends AbstractTemplateGenerator
implements ContentHandler {
    private static final String XML_FILE_EXTENSION = ".xml";
    private File templateFile = null;
    private StringBuffer buffer = null;
    private Document domDocument;
    private Node domRoot = null;
    private Node currentNode = null;
    private static final int START_ELEMENT = 0;
    private static final int END_ELEMENT = 1;
    private int lastOp = 0;

    public XMLTemplateGenerator(String prefix) {
        super(prefix);
    }

    public void generate(File file) throws Exception {
        String path = file.getAbsolutePath();
        this.templateFile = new File(path.replace(XML_FILE_EXTENSION, ".vm"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.endsWith(".dtd")) {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
                return null;
            }
        });
        this.domDocument = builder.parse(file);
        this.domRoot = this.domDocument.getDocumentElement();
        XMLReader saxReader = XMLReaderFactory.createXMLReader();
        saxReader.setContentHandler(this);
        saxReader.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.endsWith(".dtd")) {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
                return null;
            }
        });
        saxReader.parse(new InputSource(new FileInputStream(file)));
    }

    public void startDocument() throws SAXException {
        this.buffer = new StringBuffer();
    }

    public void endDocument() throws SAXException {
        try {
            String line;
            DOMSource source = new DOMSource(this.domDocument);
            File tmpFile = File.createTempFile(this.prefix, "tmp");
            StreamResult resultat = new StreamResult(tmpFile);
            TransformerFactory fabrique = TransformerFactory.newInstance();
            Transformer transformer = fabrique.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, resultat);
            BufferedReader in = new BufferedReader(new FileReader(tmpFile));
            BufferedWriter out = new BufferedWriter(new FileWriter(this.templateFile));
            out.write(this.buffer.toString());
            while ((line = in.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
            out.close();
            in.close();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.currentNode == null) {
            this.currentNode = this.domRoot;
        } else {
            this.currentNode = this.lastOp == 0 ? this.currentNode.getFirstChild() : this.currentNode.getNextSibling();
            if (!(this.currentNode instanceof Element)) {
                do {
                    this.currentNode = this.currentNode.getNextSibling();
                } while (!(this.currentNode instanceof Element));
            }
            this.lastOp = 0;
            for (int i = 0; i < atts.getLength(); ++i) {
                String templateVar = this.format(name + "-" + atts.getLocalName(i));
                if (!this.templateVars.add(templateVar)) {
                    int idx = 1;
                    String tmp = templateVar;
                    do {
                        templateVar = tmp + "-" + idx;
                        ++idx;
                    } while (!this.templateVars.add(templateVar));
                }
                this.buffer.append(this.getDefaultPattern(templateVar, atts.getValue(i)));
                this.buffer.append("\n");
                ((Element)this.currentNode).getAttributeNode(atts.getLocalName(i)).setNodeValue("${" + templateVar + "}");
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.lastOp == 1) {
            this.currentNode = this.currentNode.getParentNode();
        }
        this.lastOp = 1;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if (!value.contains(" ") && !value.contains("\n")) {
            String templateVar = this.format(this.currentNode.getNodeName());
            this.templateVars.add(templateVar);
            this.buffer.append(this.getDefaultPattern(templateVar, value));
            this.buffer.append("\n");
            this.currentNode.setTextContent("${" + templateVar + "}");
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public static void main(String[] args) {
        XMLTemplateGenerator xtg = new XMLTemplateGenerator("jonas_realm");
        File jgroupshaProps = new File("/home/legrandj/Desktop/conf/jonas-realm.xml");
        try {
            xtg.generate(jgroupshaProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

