/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.util.introspection.MethodMap;

public class ClassMap {
    private static final boolean debugReflection = false;
    private final Log log;
    private final Class clazz;
    private final MethodCache methodCache;

    public ClassMap(Class clazz, Log log) {
        this.clazz = clazz;
        this.log = log;
        this.methodCache = new MethodCache(log);
        this.populateMethodCache();
    }

    public Class getCachedClass() {
        return this.clazz;
    }

    public Method findMethod(String name, Object[] params) throws MethodMap.AmbiguousException {
        return this.methodCache.get(name, params);
    }

    private void populateMethodCache() {
        ArrayList classesToReflect = new ArrayList();
        for (Class classToReflect = this.getCachedClass(); classToReflect != null; classToReflect = classToReflect.getSuperclass()) {
            if (Modifier.isPublic(classToReflect.getModifiers())) {
                classesToReflect.add(classToReflect);
            }
            Class<?>[] classArray = classToReflect.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!Modifier.isPublic(classArray[i].getModifiers())) continue;
                classesToReflect.add(classArray[i]);
            }
        }
        for (Class clazz : classesToReflect) {
            try {
                Method[] methods = clazz.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    int modifiers = methods[i].getModifiers();
                    if (!Modifier.isPublic(modifiers) || !clazz.isInterface() && Modifier.isAbstract(modifiers)) continue;
                    this.methodCache.put(methods[i]);
                }
            }
            catch (SecurityException se) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("While accessing methods of " + clazz + ": ", se);
            }
        }
    }

    private static final class MethodCache {
        private static final CacheMiss CACHE_MISS = new CacheMiss();
        private static final Object OBJECT = new Object();
        private static final Map convertPrimitives = new HashMap();
        private final Log log;
        private final Map cache = new HashMap();
        private final MethodMap methodMap = new MethodMap();

        private MethodCache(Log log) {
            this.log = log;
        }

        public synchronized Method get(String name, Object[] params) throws MethodMap.AmbiguousException {
            String methodKey = this.makeMethodKey(name, params);
            Object cacheEntry = this.cache.get(methodKey);
            if (cacheEntry == CACHE_MISS) {
                return null;
            }
            if (cacheEntry == null) {
                try {
                    cacheEntry = this.methodMap.find(name, params);
                }
                catch (MethodMap.AmbiguousException ae) {
                    this.cache.put(methodKey, CACHE_MISS);
                    throw ae;
                }
                this.cache.put(methodKey, cacheEntry != null ? cacheEntry : CACHE_MISS);
            }
            return (Method)cacheEntry;
        }

        public synchronized void put(Method method) {
            String methodKey = this.makeMethodKey(method);
            if (this.cache.get(methodKey) == null) {
                this.cache.put(methodKey, method);
                this.methodMap.add(method);
            }
        }

        private String makeMethodKey(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            StringBuffer methodKey = new StringBuffer(method.getName());
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (parameterTypes[j].isPrimitive()) {
                    methodKey.append((String)convertPrimitives.get(parameterTypes[j]));
                    continue;
                }
                methodKey.append(parameterTypes[j].getName());
            }
            return methodKey.toString();
        }

        private String makeMethodKey(String method, Object[] params) {
            StringBuffer methodKey = new StringBuffer().append(method);
            for (int j = 0; j < params.length; ++j) {
                Object arg = params[j];
                if (arg == null) {
                    arg = OBJECT;
                }
                methodKey.append(arg.getClass().getName());
            }
            return methodKey.toString();
        }

        static {
            convertPrimitives.put(Boolean.TYPE, Boolean.class.getName());
            convertPrimitives.put(Byte.TYPE, Byte.class.getName());
            convertPrimitives.put(Character.TYPE, Character.class.getName());
            convertPrimitives.put(Double.TYPE, Double.class.getName());
            convertPrimitives.put(Float.TYPE, Float.class.getName());
            convertPrimitives.put(Integer.TYPE, Integer.class.getName());
            convertPrimitives.put(Long.TYPE, Long.class.getName());
            convertPrimitives.put(Short.TYPE, Short.class.getName());
        }

        private static final class CacheMiss {
            private CacheMiss() {
            }
        }
    }
}

