/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.admin.ClusterConnectionFactory;
import org.ow2.jasmine.jade.resources.joram.JoramOptimizationManager;

public class OptimizedClusterConnectionFactory
extends ClusterConnectionFactory {
    private JoramOptimizationManager manager = null;

    public void addConnectionFactory(String location, ConnectionFactory cf) {
        if (this.cluster == null) {
            this.cluster = new Hashtable();
        }
        if (location == null) {
            location = cf.getParameters().getHost();
        }
        this.cluster.put(location, cf);
        System.out.println("cluster connection factory: " + this.cluster);
    }

    protected ConnectionFactory getConnectionFactory() throws JMSException {
        String location = System.getProperty("location");
        String clusterQueue = System.getProperty("joram.clusterQueue");
        int prodWeight = 0;
        int consWeight = 0;
        try {
            prodWeight = Integer.parseInt(System.getProperty("joram.prodWeight"));
        }
        catch (Exception e) {
            prodWeight = 0;
        }
        try {
            consWeight = Integer.parseInt(System.getProperty("joram.consWeight"));
        }
        catch (Exception e) {
            consWeight = 0;
        }
        if (clusterQueue != null && (prodWeight > 0 || consWeight > 0)) {
            if (this.manager == null) {
                try {
                    String registryHost = System.getProperty("registry.hostname");
                    Registry reg = LocateRegistry.getRegistry(registryHost);
                    this.manager = (JoramOptimizationManager)reg.lookup("JoramManager");
                    System.out.println("MANAGER: " + this.manager);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.manager != null) {
                try {
                    location = this.manager.getLocation(clusterQueue, prodWeight, consWeight);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (location != null) {
            System.setProperty("location", location);
        }
        ConnectionFactory cf = super.getConnectionFactory();
        Enumeration key = this.cluster.keys();
        String loc = "";
        while (key.hasMoreElements()) {
            loc = (String)key.nextElement();
            if (cf != (ConnectionFactory)this.cluster.get(loc)) continue;
            System.setProperty("location", loc);
            if (this.manager == null) break;
            try {
                this.manager.update(clusterQueue, location, loc, prodWeight, consWeight);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
        return cf;
    }
}

