/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import javax.jms.TopicConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.PlatformAdminMBean;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.util.monolog.api.BasicLevel;

public class PlatformAdmin
implements PlatformAdminMBean {
    public PlatformAdmin() throws ConnectException, AdminException {
        this.connect("root", "root", 60);
        this.registerMBean();
    }

    public PlatformAdmin(String hostName, int port, String name, String password, int cnxTimer, String reliableClass) throws UnknownHostException, ConnectException, AdminException {
        this.connect(hostName, port, name, password, cnxTimer, reliableClass);
        this.registerMBean();
    }

    public PlatformAdmin(String hostName, int port, String name, String password, int cnxTimer) throws UnknownHostException, ConnectException, AdminException {
        this.connect(hostName, port, name, password, cnxTimer, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
        this.registerMBean();
    }

    public PlatformAdmin(String name, String password) throws ConnectException, AdminException {
        this.collocatedConnect(name, password);
        this.registerMBean();
    }

    public PlatformAdmin(TopicConnectionFactory cnxFact, String name, String password) throws ConnectException, AdminException {
        this.connect(cnxFact, name, password);
        this.registerMBean();
    }

    private void registerMBean() {
        block2: {
            try {
                MXWrapper.registerMBean((Object)this, (String)"joramClient", (String)"type=PlatformAdmin");
            }
            catch (Exception e) {
                if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block2;
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"registerMBean", (Throwable)e);
            }
        }
    }

    private void unregisterMBean() {
        block2: {
            try {
                MXWrapper.unregisterMBean((String)"joramClient", (String)"type=PlatformAdmin");
            }
            catch (Exception e) {
                if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block2;
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"unregisterMBean", (Throwable)e);
            }
        }
    }

    public void connect(TopicConnectionFactory cnxFact, String name, String password) throws ConnectException, AdminException {
        AdminModule.connect(cnxFact, name, password);
    }

    public void connect(String hostName, int port, String name, String password, int cnxTimer, String reliableClass) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.connect(hostName, port, name, password, cnxTimer, reliableClass);
    }

    public void connect(String name, String password, int cnxTimer) throws ConnectException, AdminException {
        try {
            this.connect("localhost", 16010, name, password, cnxTimer, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
        }
        catch (UnknownHostException exc) {
            throw new AdminException(exc.getMessage());
        }
    }

    public void collocatedConnect(String name, String password) throws ConnectException, AdminException {
        AdminModule.collocatedConnect(name, password);
    }

    public void disconnect() {
        AdminModule.disconnect();
    }

    public void exit() {
        this.disconnect();
        this.unregisterMBean();
    }

    public void stopServer(int serverId) throws ConnectException, AdminException {
        AdminModule.stopServer(serverId);
    }

    public void stopServer() throws ConnectException, AdminException {
        AdminModule.stopServer();
    }

    public void addServer(int sid, String hostName, String domainName, int port, String serverName) throws ConnectException, AdminException {
        AdminModule.addServer(sid, hostName, domainName, port, serverName);
    }

    public void removeServer(int sid) throws ConnectException, AdminException {
        AdminModule.removeServer(sid);
    }

    public void addDomain(String domainName, int sid, int port) throws ConnectException, AdminException {
        AdminModule.addDomain(domainName, sid, port);
    }

    public void removeDomain(String domainName) throws ConnectException, AdminException {
        AdminModule.removeDomain(domainName);
    }

    public String getConfiguration() throws ConnectException, AdminException {
        return AdminModule.getConfiguration();
    }

    public List getServersIds() {
        try {
            return AdminModule.getServersIds();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public List getServersIds(String domainName) throws ConnectException, AdminException {
        return AdminModule.getServersIds(domainName);
    }

    public String[] getDomainNames(int serverId) throws ConnectException, AdminException {
        return AdminModule.getDomainNames(serverId);
    }

    public void setDefaultThreshold(int serverId, int threshold) throws ConnectException, AdminException {
        AdminModule.setDefaultThreshold(serverId, threshold);
    }

    public void setDefaultThreshold(int threshold) throws ConnectException, AdminException {
        AdminModule.setDefaultThreshold(threshold);
    }

    public int getDefaultThreshold(int serverId) throws ConnectException, AdminException {
        return AdminModule.getDefaultThreshold(serverId);
    }

    public int getDefaultThreshold() throws ConnectException, AdminException {
        return AdminModule.getDefaultThreshold();
    }

    public int getLocalServerId() throws ConnectException {
        return AdminModule.getLocalServerId();
    }

    public String getLocalHost() throws ConnectException {
        return AdminModule.getLocalHost();
    }

    public int getLocalPort() throws ConnectException {
        return AdminModule.getLocalPort();
    }
}

